/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.local;

import java.io.IOException;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.reqcycle.repository.connector.local.ui.dialog.UseAsSourceDialog;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementsContainer;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class UseAsSourceHandler
extends AbstractHandler {
    @Inject
    IDataManager dataManager;

    public UseAsSourceHandler() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Object firstElement;
            ISelection activeMenuSelection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
            if (activeMenuSelection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)activeMenuSelection).getFirstElement()) instanceof IFile) {
                IFile file = (IFile)firstElement;
                ResourceSetImpl rs = new ResourceSetImpl();
                Resource resource = rs.getResource(URI.createURI((String)file.getFullPath().toString()), true);
                EList contents = resource.getContents();
                for (EObject eObject : contents) {
                    if (!(eObject instanceof RequirementsContainer)) continue;
                    UseAsSourceDialog dialog = new UseAsSourceDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
                    dialog.init(file.getLocation().removeFileExtension().lastSegment());
                    if (dialog.open() != 0) continue;
                    RequirementSource source = this.dataManager.createRequirementSource();
                    source.setName(dialog.bean.getSourceName());
                    source.setDataModelURI(dialog.bean.getDataModel().getDataModelURI());
                    source.setDefaultScope(dialog.bean.getScope());
                    source.setConnectorId("org.polarsys.reqcycle.repository.connector.local.connectorCore");
                    source.setContents((RequirementsContainer)eObject);
                    source.setDestinationURI(eObject.eResource().getURI().toString());
                    this.dataManager.addRequirementSource(source);
                }
                try {
                    this.dataManager.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (RuntimeException e) {
            ErrorDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"error", (String)e.getMessage(), (IStatus)Status.CANCEL_STATUS, (int)8);
            e.printStackTrace();
        }
        return null;
    }
}

