/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.configuration.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.configuration.impl.EMFConfResourceFactory;
import org.polarsys.reqcycle.utils.configuration.impl.RestrictedResourceSet;

@Singleton
public class ConfigurationManagerImpl
implements IConfigurationManager {
    protected static final Map<?, ?> SAVE_OPTIONS = Collections.singletonMap("SCHEMA_LOCATION", true);
    public static final String CONF_RESOURCE_EXTENSION = "emfconf";
    public ResourceSet internalResourceSet = new ResourceSetImpl();
    protected static final Pattern SANE_FILENAME_PATTERN = Pattern.compile("[^a-zA-Z0-9\\._]+");

    @Override
    public void saveConfiguration(Collection<? extends EObject> conf, IResource context, IConfigurationManager.Scope scope, String id, ResourceSet resourceSet, String resourceExtension) throws IOException {
        Resource r;
        if (context == null && IConfigurationManager.Scope.PROJECT.equals((Object)scope)) {
            throw new IOException("Context should not be null when using project scope");
        }
        if (scope == null || context == null) {
            scope = IConfigurationManager.Scope.WORKSPACE;
        }
        if (resourceSet == null) {
            resourceSet = this.internalResourceSet;
        } else {
            resourceExtension = null;
        }
        URI confFileUri = this.getConfigurationFileURI(context, scope, id, resourceExtension);
        if (resourceSet instanceof RestrictedResourceSet) {
            ((RestrictedResourceSet)resourceSet).authorizedUris.add(confFileUri);
        }
        if ((r = resourceSet.getResource(confFileUri, false)) == null) {
            r = resourceSet.createResource(confFileUri);
        }
        r.getContents().clear();
        r.getContents().addAll(conf);
        if (r instanceof EMFConfResourceFactory.EMFConfResource) {
            ((EMFConfResourceFactory.EMFConfResource)r).manualSave(SAVE_OPTIONS);
        } else {
            r.save(SAVE_OPTIONS);
        }
    }

    @Override
    public Collection<EObject> getConfiguration(IResource context, IConfigurationManager.Scope scope, String id, ResourceSet resourceSet, String resourceExtension, boolean reload) {
        block7: {
            if (resourceSet == null) {
                resourceSet = this.internalResourceSet;
            } else {
                resourceExtension = null;
            }
            URI confFileURI = this.getConfigurationFileURI(context, scope, id, resourceExtension);
            if (resourceSet instanceof RestrictedResourceSet) {
                ((RestrictedResourceSet)resourceSet).addAuthorizedUri(confFileURI);
            }
            try {
                Resource r;
                Resource loadedResource = resourceSet.getResource(confFileURI, false);
                if (reload && loadedResource != null && loadedResource.isLoaded()) {
                    loadedResource.unload();
                    resourceSet.getResources().remove((Object)loadedResource);
                }
                if ((r = resourceSet.getResource(confFileURI, true)) != null && !r.getContents().isEmpty()) {
                    return r.getContents();
                }
            }
            catch (Throwable e) {
                Throwable cause;
                if (!(e instanceof WrappedException) || (cause = e.getCause()) instanceof FileNotFoundException) break block7;
                throw (WrappedException)e;
            }
        }
        return null;
    }

    protected String sanatizeForFilename(String name) {
        return SANE_FILENAME_PATTERN.matcher(name).replaceAll("_");
    }

    protected boolean isSelfContained(EObject eObj) {
        return true;
    }

    protected boolean hasOutsideReferences(EObject obj, Set<EObject> containedObjs) {
        for (EReference ref : obj.eClass().getEAllReferences()) {
            if (!obj.eIsSet((EStructuralFeature)ref) || ref.isContainment()) continue;
            if (ref.isMany()) {
                List values = (List)obj.eGet((EStructuralFeature)ref);
                for (Object val : values) {
                    if (val == null || containedObjs.contains(val)) continue;
                    return true;
                }
                continue;
            }
            Object val = obj.eGet((EStructuralFeature)ref);
            if (val == null || containedObjs.contains(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public URI getConfigurationFileURI(IResource context, IConfigurationManager.Scope scope, String id, String resourceExtension) {
        id = this.sanatizeForFilename(id);
        if (resourceExtension == null || "".equals(resourceExtension)) {
            resourceExtension = CONF_RESOURCE_EXTENSION;
        }
        IPath confFilePath = null;
        if (context != null && context.getProject() != null && (scope == null || IConfigurationManager.Scope.PROJECT.equals((Object)scope))) {
            confFilePath = context.getProject().getFullPath().append("/.settings/org.polarsys.reqcycle.utils.configuration/" + id + "." + resourceExtension);
            IFile confFile = ResourcesPlugin.getWorkspace().getRoot().getFile(confFilePath);
            if (!confFile.exists() && scope == null) {
                confFilePath = null;
            }
        }
        if (confFilePath == null && (scope == null || IConfigurationManager.Scope.WORKSPACE.equals((Object)scope))) {
            return URI.createURI((String)("platform:/meta/org.polarsys.reqcycle.utils.configuration/" + id + "." + resourceExtension));
        }
        return URI.createPlatformResourceURI((String)confFilePath.toOSString(), (boolean)true);
    }

    @Override
    public String getConfigurationResourceExtension() {
        return CONF_RESOURCE_EXTENSION;
    }

    @Override
    public Map<String, Object> getSimpleConfiguration(IResource context, IConfigurationManager.Scope scope, String id, boolean reload) {
        EObject confEObj = null;
        Collection<EObject> conf = this.getConfiguration(context, scope, id, this.internalResourceSet, null, reload);
        if (conf != null && !conf.isEmpty()) {
            confEObj = conf.iterator().next();
        }
        if (confEObj == null) {
            return null;
        }
        HashMap res = Maps.newHashMap();
        for (EAttribute att : confEObj.eClass().getEAllAttributes()) {
            if (att.isMany()) {
                List l = (List)confEObj.eGet((EStructuralFeature)att);
                ArrayList newList = Lists.newArrayList();
                for (Object o : l) {
                    newList.add(o);
                }
                res.put(att.getName(), newList);
                continue;
            }
            res.put(att.getName(), confEObj.eGet((EStructuralFeature)att));
        }
        return res;
    }

    @Override
    public void saveSimpleConfiguration(Map<String, Object> conf, IResource context, IConfigurationManager.Scope scope, String id) throws IOException {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName(CONF_RESOURCE_EXTENSION);
        ePackage.setNsPrefix(CONF_RESOURCE_EXTENSION);
        ePackage.setNsURI("http://www.eclipse.org/emfconf/" + EcoreUtil.generateUUID());
        EFactory eFactory = EcoreFactory.eINSTANCE.createEFactory();
        eFactory.setEPackage(ePackage);
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName("Conf");
        ePackage.getEClassifiers().add((Object)eClass);
        for (Map.Entry<String, Object> elem : conf.entrySet()) {
            EClassifier currentType = null;
            int upperBound = 1;
            if (elem.getValue() instanceof Collection) {
                upperBound = -1;
                for (Object o : (Collection)elem.getValue()) {
                    if (o == null) continue;
                    EClassifier oType = this.getEType(o);
                    if (oType == null) {
                        throw new IOException("Unsupported value type");
                    }
                    if (oType instanceof EDataType && !oType.equals(oType)) {
                        throw new IOException("Incoherent collection (values of different types)");
                    }
                    if (!(oType instanceof EClass)) continue;
                    if (currentType == null) {
                        currentType = oType;
                        continue;
                    }
                    if (currentType instanceof EClass) {
                        if (((EClass)currentType).isSuperTypeOf(eClass)) continue;
                        if (((EClass)oType).isSuperTypeOf((EClass)currentType)) {
                            currentType = oType;
                            continue;
                        }
                        throw new IOException("Incoherent collection (values of different types)");
                    }
                    throw new IOException("Incoherent collection (values of different types)");
                }
            } else {
                currentType = this.getEType(elem.getValue());
            }
            EReference feature = null;
            if (currentType instanceof EClass) {
                feature = EcoreFactory.eINSTANCE.createEReference();
            } else if (currentType instanceof EDataType) {
                feature = EcoreFactory.eINSTANCE.createEAttribute();
            }
            if (feature == null) {
                throw new IOException("Unsupported value type");
            }
            feature.setName(elem.getKey());
            feature.setUpperBound(upperBound);
            feature.setEType(currentType);
            eClass.getEStructuralFeatures().add((Object)feature);
        }
        URI mmFileUri = this.getConfigurationFileURI(context, scope, id, "ecore");
        Resource mmResource = this.internalResourceSet.getResource(mmFileUri, false);
        if (mmResource == null) {
            mmResource = this.internalResourceSet.createResource(mmFileUri);
        }
        mmResource.getContents().clear();
        mmResource.getContents().add((Object)ePackage);
        mmResource.save(null);
        EObject confEObj = eFactory.create(eClass);
        for (Map.Entry<String, Object> elem : conf.entrySet()) {
            Object value = elem.getValue();
            if (value instanceof Iterable) {
                List l = (List)confEObj.eGet(eClass.getEStructuralFeature(elem.getKey()));
                for (Object o : (Iterable)value) {
                    if (o instanceof EObject && !this.isSelfContained((EObject)o)) {
                        throw new IOException("The configuration object have reference(s) outside of itself and its children");
                    }
                    l.add(o);
                }
                continue;
            }
            if (value instanceof EObject && !this.isSelfContained((EObject)value)) {
                throw new IOException("The configuration object have reference(s) outside of itself and its children");
            }
            confEObj.eSet(eClass.getEStructuralFeature(elem.getKey()), value);
        }
        this.saveConfiguration(Collections.singleton(confEObj), context, scope, id, null, null);
    }

    protected EClassifier getEType(Object obj) {
        if (obj instanceof EObject) {
            return ((EObject)obj).eClass();
        }
        if (obj instanceof String) {
            return EcorePackage.Literals.ESTRING;
        }
        if (obj instanceof Integer) {
            return EcorePackage.Literals.EINTEGER_OBJECT;
        }
        if (obj instanceof Long) {
            return EcorePackage.Literals.ELONG_OBJECT;
        }
        if (obj instanceof Boolean) {
            return EcorePackage.Literals.EBOOLEAN_OBJECT;
        }
        if (obj instanceof Double) {
            return EcorePackage.Literals.EDOUBLE_OBJECT;
        }
        if (obj instanceof Float) {
            return EcorePackage.Literals.EFLOAT_OBJECT;
        }
        return null;
    }

    @Override
    public ResourceSet getConfigurationResourceSet() {
        return this.internalResourceSet;
    }

    @Override
    public void unload() {
        this.internalResourceSet = new ResourceSetImpl();
    }
}

