/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.ui.views;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.wb.swt.ResourceManager;
import org.polarsys.reqcycle.dnd.DNDReqCycle;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.model.scopes.Scopes;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.storage.NoProjectStorageException;
import org.polarsys.reqcycle.traceability.types.conditions.TypeConditions;
import org.polarsys.reqcycle.traceability.types.scopes.ConfigurationScope;
import org.polarsys.reqcycle.traceability.ui.TraceabilityUtils;
import org.polarsys.reqcycle.traceability.ui.providers.BusinessDeffered;
import org.polarsys.reqcycle.traceability.ui.providers.RequestContentProvider;
import org.polarsys.reqcycle.traceability.ui.providers.RequestLabelProvider;
import org.polarsys.reqcycle.traceability.ui.services.ILocateService;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.types.ui.providers.IterableOfTypesContentProvider;
import org.polarsys.reqcycle.types.ui.providers.TypeLabelProvider;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IObjectHandler;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilityViewer
extends ViewPart
implements ISelectionListener {
    private static final String PLUGIN_ID = "org.polarsys.reqcycle.traceability.ui";
    public static final String ID = "org.polarsys.reqcycle.traceability.ui.views.TraceabilityViewer";
    public static final String MENU_ID = "org.polarsys.reqcycle.traceability.ui.views.TraceabilityViewer.menu";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Text targetText;
    private Set<Reachable> sources = new HashSet<Reachable>();
    private Object target;
    private ISelection selection;
    private TreeViewer traceabilityTreeViewer;
    private ComboViewer comboDirectionViewer;
    private ITraceabilityEngine.DIRECTION direction;
    private RequestContentProvider contentProvider;
    private TreeViewer listOfTypesViewer;
    private ITypesManager manager = (ITypesManager)ZigguratInject.make(ITypesManager.class);
    private IReachableManager reachManager = (IReachableManager)ZigguratInject.make(IReachableManager.class);
    private ILocateService locateService = (ILocateService)ZigguratInject.make(ILocateService.class);
    private Action delete_action;
    private Action refresh_action;
    private Action plus_action;
    private Action sync_action;
    private Action new_instance;
    private Action changeViewName;
    private Button btnFilterOnCurrent;
    private Action locateAction;
    private Action deleteAction;
    @Inject
    protected IStorageProvider provider;
    @Inject
    protected IReachableListenerManager listenerManager;

    public TraceabilityViewer() {
        this.setTitleImage(ResourceManager.getPluginImage(PLUGIN_ID, "icons/path.gif"));
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.contentProvider.dispose();
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(256));
        Form frmNewForm = this.formToolkit.createForm(container);
        this.formToolkit.paintBordersFor((Composite)frmNewForm);
        frmNewForm.setText("Traceability");
        frmNewForm.getBody().setLayout((Layout)new FillLayout(256));
        Composite composite_3 = this.formToolkit.createComposite(frmNewForm.getBody(), 0);
        this.formToolkit.paintBordersFor(composite_3);
        composite_3.setLayout((Layout)new GridLayout(1, false));
        this.contentProvider = new RequestContentProvider();
        RequestLabelProvider labelProvider = new RequestLabelProvider();
        ZigguratInject.inject((Object[])new Object[]{labelProvider, this.contentProvider});
        Composite compoTrac = this.formToolkit.createComposite(composite_3, 0);
        compoTrac.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.formToolkit.paintBordersFor(compoTrac);
        compoTrac.setLayout((Layout)new FillLayout(256));
        Section sctTraceability = this.formToolkit.createSection(compoTrac, 352);
        sctTraceability.setText("Path Tree");
        this.formToolkit.paintBordersFor((Composite)sctTraceability);
        Composite composite_1 = this.formToolkit.createComposite((Composite)sctTraceability, 0);
        this.formToolkit.paintBordersFor(composite_1);
        sctTraceability.setClient((Control)composite_1);
        composite_1.setLayout((Layout)new GridLayout(1, false));
        this.traceabilityTreeViewer = new TreeViewer(composite_1, 0x10000800);
        this.getSite().setSelectionProvider((ISelectionProvider)this.traceabilityTreeViewer);
        this.createDropTarget((Control)this.traceabilityTreeViewer.getTree());
        this.traceabilityTreeViewer.setUseHashlookup(true);
        this.traceabilityTreeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.traceabilityTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.traceabilityTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (firstElement instanceof Reachable) {
                    Reachable reachable = (Reachable)firstElement;
                    TraceabilityViewer.this.listOfTypesViewer.setInput((Object)TraceabilityViewer.this.manager.getAllApplicableTypes(reachable));
                } else {
                    TraceabilityViewer.this.listOfTypesViewer.setInput(null);
                }
            }
        });
        Tree treeTraceability = this.traceabilityTreeViewer.getTree();
        GridData gd_treeTraceability = new GridData(4, 4, true, true, 1, 1);
        gd_treeTraceability.heightHint = 286;
        treeTraceability.setLayoutData((Object)gd_treeTraceability);
        this.formToolkit.paintBordersFor((Composite)treeTraceability);
        MenuManager menuManager = new MenuManager();
        this.locateAction = new Action("Locate", ResourceManager.getPluginImageDescriptor(PLUGIN_ID, "icons/locate.gif")){

            public void run() {
                Reachable reachable = TraceabilityViewer.this.getSelectedReachable();
                try {
                    TraceabilityViewer.this.locateService.open(reachable);
                }
                catch (Exception e) {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)e.getMessage(), (IStatus)Status.OK_STATUS);
                }
            }
        };
        menuManager.add((IAction)this.locateAction);
        menuManager.add((IContributionItem)new Separator());
        this.deleteAction = new Action("Delete link", ResourceManager.getPluginImageDescriptor(PLUGIN_ID, "icons/delete_obj.gif")){

            public void run() {
                BusinessDeffered busi;
                IStructuredSelection structured;
                ISelection selec = TraceabilityViewer.this.traceabilityTreeViewer.getSelection();
                if (selec instanceof IStructuredSelection && (structured = (IStructuredSelection)selec).getFirstElement() instanceof BusinessDeffered && (busi = (BusinessDeffered)structured.getFirstElement()).getBusinessElement() instanceof Link) {
                    Link link = (Link)busi.getBusinessElement();
                    Reachable source = (Reachable)Iterables.get((Iterable)link.getSources(), (int)0);
                    Reachable target = (Reachable)Iterables.get((Iterable)link.getTargets(), (int)0);
                    ITraceabilityStorage storage = null;
                    HashSet notification = Sets.newHashSet();
                    try {
                        try {
                            storage = TraceabilityViewer.this.provider.getProjectStorageFromLinkId(link.getId());
                            if (storage != null) {
                                storage.startTransaction();
                                storage.removeTraceabilityLink(link.getId());
                                notification.add(link.getId());
                                notification.add(source);
                                notification.add(target);
                                notification.add(link.getId().trimFragment());
                                storage.commit();
                                TraceabilityViewer.this.listenerManager.notifyChanged(notification.toArray(new Reachable[0]));
                            }
                        }
                        catch (NoProjectStorageException e) {
                            e.printStackTrace();
                            if (storage != null) {
                                storage.save();
                                storage.dispose();
                            }
                        }
                    }
                    finally {
                        if (storage != null) {
                            storage.save();
                            storage.dispose();
                        }
                    }
                }
            }
        };
        menuManager.add((IAction)this.deleteAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new Action("Show Properties view", ResourceManager.getPluginImageDescriptor(PLUGIN_ID, "icons/properties-1.gif")){

            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Menu menu = menuManager.createContextMenu((Control)treeTraceability);
        this.getSite().registerContextMenu(MENU_ID, menuManager, (ISelectionProvider)this.traceabilityTreeViewer);
        treeTraceability.setMenu(menu);
        this.traceabilityTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (firstElement instanceof BusinessDeffered) {
                    BusinessDeffered busi = (BusinessDeffered)firstElement;
                    firstElement = busi.getBusinessElement();
                }
                if (firstElement instanceof Reachable) {
                    Reachable reachable = (Reachable)firstElement;
                    TraceabilityViewer.this.listOfTypesViewer.setInput((Object)TraceabilityViewer.this.manager.getAllApplicableTypes(reachable));
                } else {
                    TraceabilityViewer.this.listOfTypesViewer.setInput(null);
                }
            }
        });
        Composite compoParam = this.formToolkit.createComposite(composite_3, 0);
        compoParam.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 2));
        this.formToolkit.paintBordersFor(compoParam);
        compoParam.setLayout((Layout)new FillLayout(256));
        Section sctnParameters = this.formToolkit.createSection(compoParam, 2);
        this.formToolkit.paintBordersFor((Composite)sctnParameters);
        sctnParameters.setText("Parameters");
        Composite composite = this.formToolkit.createComposite((Composite)sctnParameters, 0);
        this.formToolkit.paintBordersFor(composite);
        sctnParameters.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(5, false));
        Label lblTarget = this.formToolkit.createLabel(composite, "target :", 0);
        lblTarget.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.targetText = this.formToolkit.createText(composite, "New Text", 0);
        this.targetText.setEditable(false);
        this.targetText.setText("");
        this.targetText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createDropTarget((Control)this.targetText);
        Button btnChooseType = this.formToolkit.createButton(composite, "...", 0);
        btnChooseType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ElementTreeSelectionDialog d = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new TypeLabelProvider(), (ITreeContentProvider)new IterableOfTypesContentProvider());
                d.setInput((Object)TraceabilityViewer.this.manager.getAllTypes());
                if (d.open() == 0) {
                    IType firstResult = (IType)d.getFirstResult();
                    TraceabilityViewer.this.target = firstResult;
                    TraceabilityViewer.this.targetText.setText(firstResult.getLabel());
                }
            }
        });
        Button btnAddTarget = this.formToolkit.createButton(composite, "", 0);
        btnAddTarget.setImage(ResourceManager.getPluginImage(PLUGIN_ID, "icons/add_obj.gif"));
        btnAddTarget.addSelectionListener((SelectionListener)new AddSelectionListener(new TargetSetter()));
        Button btnDeleteTarget = this.formToolkit.createButton(composite, "", 0);
        btnDeleteTarget.setImage(ResourceManager.getPluginImage(PLUGIN_ID, "icons/delete_obj.gif"));
        btnDeleteTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceabilityViewer.this.target = null;
                TraceabilityViewer.this.targetText.setText("");
            }
        });
        Label lblDirection = this.formToolkit.createLabel(composite, "direction :", 0);
        lblDirection.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.comboDirectionViewer = new ComboViewer(composite, 8);
        Combo combo = this.comboDirectionViewer.getCombo();
        this.comboDirectionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboDirectionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return super.getText((Object)element.toString());
            }
        });
        this.comboDirectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TraceabilityViewer.this.direction = (ITraceabilityEngine.DIRECTION)((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        this.comboDirectionViewer.setInput(Arrays.asList(ITraceabilityEngine.DIRECTION.UPWARD, ITraceabilityEngine.DIRECTION.DOWNWARD));
        this.comboDirectionViewer.setSelection((ISelection)new StructuredSelection((Object)ITraceabilityEngine.DIRECTION.DOWNWARD));
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.formToolkit.paintBordersFor((Composite)combo);
        Label lblConfiguration = new Label(composite, 0);
        lblConfiguration.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.formToolkit.adapt((Control)lblConfiguration, true, true);
        lblConfiguration.setText("configuration :");
        this.btnFilterOnCurrent = new Button(composite, 32);
        this.btnFilterOnCurrent.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.formToolkit.adapt((Control)this.btnFilterOnCurrent, true, true);
        this.btnFilterOnCurrent.setText("Filter on current configuration");
        Composite composite_4 = new Composite(composite_3, 0);
        composite_4.setLayout((Layout)new FillLayout(256));
        composite_4.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.formToolkit.adapt(composite_4);
        this.formToolkit.paintBordersFor(composite_4);
        Section sctnTypesOfSelection = this.formToolkit.createSection(composite_4, 2);
        this.formToolkit.paintBordersFor((Composite)sctnTypesOfSelection);
        sctnTypesOfSelection.setText("Type(s) of selection");
        Composite composite_2 = new Composite((Composite)sctnTypesOfSelection, 0);
        this.formToolkit.adapt(composite_2);
        this.formToolkit.paintBordersFor(composite_2);
        sctnTypesOfSelection.setClient((Control)composite_2);
        composite_2.setLayout((Layout)new FillLayout(256));
        this.listOfTypesViewer = new TreeViewer(composite_2, 2560);
        this.listOfTypesViewer.setContentProvider((IContentProvider)new IterableOfTypesContentProvider());
        this.listOfTypesViewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    private void createDropTarget(Control control) {
        DropTarget target = new DropTarget(control, 23);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer(), PluginTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                DropTarget drop;
                super.dragEnter(event);
                Widget widget = event.widget;
                if (widget instanceof DropTarget && (drop = (DropTarget)widget).getControl() != TraceabilityViewer.this.targetText && TraceabilityViewer.this.isSyncToSelection()) {
                    return;
                }
                int i = 0;
                while (i < event.dataTypes.length) {
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        break;
                    }
                    ++i;
                }
            }

            public void drop(DropTargetEvent event) {
                Widget widget;
                PluginTransferData ptd;
                super.drop(event);
                List<Reachable> reachables = new ArrayList();
                if (PluginTransfer.getInstance().isSupportedType(event.currentDataType) && !(reachables = DNDReqCycle.getReachables((byte[])(ptd = (PluginTransferData)event.data).getData())).isEmpty()) {
                    for (Reachable r : reachables) {
                        if (event.item != TraceabilityViewer.this.targetText) continue;
                        TargetSetter setter = new TargetSetter();
                        setter.set(r);
                    }
                }
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && event.data instanceof IStructuredSelection) {
                    IStructuredSelection structured = (IStructuredSelection)event.data;
                    for (Object o : structured) {
                        Reachable r = TraceabilityViewer.this.getReachable(o);
                        if (r == null) continue;
                        reachables.add(r);
                    }
                }
                if ((widget = event.widget) instanceof DropTarget) {
                    DropTarget drop = (DropTarget)widget;
                    ISetter setter = null;
                    if (drop.getControl() == TraceabilityViewer.this.targetText) {
                        setter = new TargetSetter();
                    } else if (!TraceabilityViewer.this.isSyncToSelection()) {
                        setter = new SourceSetter();
                    }
                    if (setter != null) {
                        if (reachables != null && !reachables.isEmpty()) {
                            for (Reachable r : reachables) {
                                setter.set(r);
                            }
                        } else {
                            setter.set(null);
                        }
                    }
                }
            }

            public void dragOver(DropTargetEvent event) {
                super.dragOver(event);
            }

            public void dropAccept(DropTargetEvent event) {
                super.dropAccept(event);
            }
        });
    }

    public void setInput() {
        if (this.sources.isEmpty()) {
            this.traceabilityTreeViewer.setInput(null);
        } else {
            CompositeScope scope = new CompositeScope();
            scope.add(Scopes.getWorkspaceScope());
            scope.add((IScope)new ConfigurationScope());
            Request request = new Request().setDirection(this.direction).setScope((IScope)scope).setDepth(Request.DEPTH.ONE).addProperty("optionCheckCache", (Object)true).addProperty("conf", (Object)this.btnFilterOnCurrent.getSelection());
            if (this.target == null) {
                for (Reachable r : this.sources) {
                    request.addSource(r);
                }
            } else {
                if (this.target instanceof Reachable) {
                    for (Reachable r : this.sources) {
                        request.addSourceAndTarget(r, (Reachable)this.target);
                    }
                } else if (this.target instanceof IType) {
                    for (Reachable r : this.sources) {
                        request.addSourceAndCondition(r, TypeConditions.is((IType)((IType)this.target)));
                    }
                }
                request.setDepth(Request.DEPTH.INFINITE);
            }
            this.traceabilityTreeViewer.setInput((Object)request);
        }
    }

    private void createActions() {
        this.delete_action = new Action("Remove selections"){

            public void run() {
                TraceabilityViewer.this.runDelete();
            }
        };
        this.delete_action.setImageDescriptor(ResourceManager.getPluginImageDescriptor(PLUGIN_ID, "icons/delete_obj.gif"));
        this.refresh_action = new Action("Refresh view"){

            public void run() {
                TraceabilityViewer.this.runRefresh();
            }
        };
        this.refresh_action.setImageDescriptor(ResourceManager.getPluginImageDescriptor(PLUGIN_ID, "icons/update.gif"));
        this.plus_action = new Action("Add current selection"){

            public void run() {
                TraceabilityViewer.this.handleCurrentSelection(new SourceSetter());
            }
        };
        this.plus_action.setImageDescriptor(ResourceManager.getPluginImageDescriptor(PLUGIN_ID, "icons/add_obj.gif"));
        this.sync_action = new Action("Sync to selection", 2){

            public void run() {
                TraceabilityViewer.this.runSync();
            }
        };
        this.sync_action.setImageDescriptor(ResourceManager.getPluginImageDescriptor(PLUGIN_ID, "icons/synced-1.gif"));
        this.new_instance = new Action("New Instance"){

            public void run() {
                TraceabilityViewer.this.createNewView();
            }
        };
        this.new_instance.setImageDescriptor(ResourceManager.getPluginImageDescriptor(PLUGIN_ID, "icons/newView.gif"));
        this.changeViewName = new Action("Change view name"){

            public void run() {
                TraceabilityViewer.this.setViewName();
            }
        };
        this.changeViewName.setImageDescriptor(ResourceManager.getPluginImageDescriptor(PLUGIN_ID, "icons/setName.gif"));
    }

    protected void setViewName() {
        String value;
        InputDialog dialog = new InputDialog(this.getSite().getShell(), "View Name", "Please enter the name of this view", this.getPartName(), null);
        if (dialog.open() == 0 && (value = dialog.getValue()) != null && value.length() > 0) {
            this.setPartName(value);
        }
    }

    protected void createNewView() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        int nbView = 0;
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().startsWith(ID)) {
                ++nbView;
            }
            ++n2;
        }
        ++nbView;
        try {
            activePage.showView(ID, "org.polarsys.reqcycle.traceability.ui.views.TraceabilityViewer_" + nbView, 1);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void initializeToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.sync_action);
        toolbarManager.add((IAction)this.plus_action);
        toolbarManager.add((IAction)this.refresh_action);
        toolbarManager.add((IAction)this.delete_action);
        toolbarManager.add((IAction)this.new_instance);
    }

    private void initializeMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.sync_action);
        menuManager.add((IAction)this.plus_action);
        menuManager.add((IAction)this.refresh_action);
        menuManager.add((IAction)this.delete_action);
        menuManager.add((IAction)this.new_instance);
        menuManager.add((IAction)this.changeViewName);
    }

    public void setFocus() {
    }

    public Reachable getReachable(Object o) {
        try {
            IObjectHandler handler = this.reachManager.getHandlerFromObject(o);
            ReachableObject reachableObject = handler.getFromObject(o);
            if (reachableObject != null) {
                return reachableObject.getReachable();
            }
        }
        catch (IReachableHandlerException iReachableHandlerException) {}
        return null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection structured;
        if (part != this && !(part instanceof PropertySheet)) {
            this.selection = selection;
            if (this.isSyncToSelection()) {
                this.sources.clear();
                this.handleCurrentSelection(new SourceSetter());
                this.setInput();
                if (this.isSyncToSelection()) {
                    this.traceabilityTreeViewer.expandToLevel(-1);
                }
            }
        } else if (part == this) {
            this.locateAction.setEnabled(this.locateService.isOpenable(this.getSelectedReachable()));
        }
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).getFirstElement() instanceof BusinessDeffered) {
            BusinessDeffered busi = (BusinessDeffered)structured.getFirstElement();
            if (busi.getBusinessElement() instanceof Link) {
                this.deleteAction.setEnabled(true);
            } else {
                this.deleteAction.setEnabled(false);
            }
        }
    }

    public boolean isSyncToSelection() {
        return this.sync_action.isChecked();
    }

    private void handleCurrentSelection(ISetter setter) {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)this.selection;
            for (Object o : structured) {
                if (o == null) {
                    setter.set(null);
                    continue;
                }
                setter.set(this.getReachable(o));
            }
        }
    }

    private void runRefresh() {
        IStructuredSelection sel = (IStructuredSelection)this.comboDirectionViewer.getSelection();
        if (sel != null && !sel.isEmpty() && !this.sources.isEmpty()) {
            this.setInput();
        }
    }

    private void runDelete() {
        this.sources.clear();
        this.setInput();
    }

    private void runSync() {
        boolean enabled = this.sync_action.isChecked();
        this.sync_action.setChecked(enabled);
        this.traceabilityTreeViewer.setData("expandAll", (Object)String.valueOf(enabled));
    }

    public void refresh() {
        this.traceabilityTreeViewer.refresh(true);
    }

    public void refreshElement(Object o) {
        this.traceabilityTreeViewer.update(o, null);
    }

    private Reachable getSelectedReachable() {
        BusinessDeffered busi;
        IStructuredSelection structured;
        ISelection selec = this.traceabilityTreeViewer.getSelection();
        if (selec instanceof IStructuredSelection && (structured = (IStructuredSelection)selec).getFirstElement() instanceof BusinessDeffered && (busi = (BusinessDeffered)structured.getFirstElement()).getBusinessElement() instanceof Reachable) {
            Reachable reach = (Reachable)busi.getBusinessElement();
            return reach;
        }
        return null;
    }

    private Link getSelectedLink() {
        BusinessDeffered busi;
        IStructuredSelection structured;
        ISelection selec = this.traceabilityTreeViewer.getSelection();
        if (selec instanceof IStructuredSelection && (structured = (IStructuredSelection)selec).getFirstElement() instanceof BusinessDeffered && (busi = (BusinessDeffered)structured.getFirstElement()).getBusinessElement() instanceof Link) {
            return (Link)busi.getBusinessElement();
        }
        return null;
    }

    private class AddSelectionListener
    implements SelectionListener {
        private ISetter setter;

        public AddSelectionListener(ISetter s) {
            this.setter = s;
        }

        public void widgetSelected(SelectionEvent e) {
            TraceabilityViewer.this.handleCurrentSelection(this.setter);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private static interface ISetter {
        public void set(Reachable var1);
    }

    private class SourceSetter
    implements ISetter {
        private SourceSetter() {
        }

        @Override
        public void set(Reachable r) {
            TraceabilityViewer.this.sources.add(r);
            TraceabilityViewer.this.setInput();
        }
    }

    private class TargetSetter
    implements ISetter {
        private TargetSetter() {
        }

        @Override
        public void set(Reachable r) {
            if (r == null) {
                TraceabilityViewer.this.targetText.setText("invalid selection");
                TraceabilityViewer.this.target = null;
            } else {
                TraceabilityViewer.this.target = r;
                TraceabilityViewer.this.targetText.setText(TraceabilityUtils.getText(r));
            }
        }
    }
}

