/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.ocl.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.helper.OCLHelper;

public class OCLtoEMFConstraintWrapper
extends AbstractConstraintDescriptor
implements IModelConstraint {
    private final OCL ocl;
    private final Constraint constraint;

    public OCLtoEMFConstraintWrapper(OCL ocl, Constraint constraint) {
        this.ocl = ocl;
        this.constraint = constraint;
    }

    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        boolean constraintResult = this.ocl.check((Object)target, this.constraint);
        if (!constraintResult) {
            String message = String.format("Object %s does not comply with constraint %s", target.toString(), this.getDescriptor().getName());
            OpaqueExpression specification = this.constraint.getSpecification();
            if (specification instanceof ExpressionInOCL) {
                Object queryResult;
                OCLExpression messageExpression = ((ExpressionInOCL)specification).getBodyExpression();
                ExpressionInOCL messageQuery = null;
                if (messageExpression instanceof ExpressionInOCL) {
                    messageQuery = (ExpressionInOCL)messageExpression;
                } else if (messageExpression != null) {
                    OCLHelper helper = this.ocl.createOCLHelper((EObject)target.eClass());
                    try {
                        messageQuery = helper.createQuery(messageExpression.toString());
                    }
                    catch (ParserException e) {
                        e.printStackTrace();
                    }
                }
                if (messageQuery != null && (queryResult = this.ocl.evaluate((Object)target, messageQuery)) instanceof String) {
                    message = (String)queryResult;
                }
            }
            return ctx.createFailureStatus(new Object[]{message});
        }
        return ctx.createSuccessStatus();
    }

    public boolean targetsTypeOf(EObject object) {
        EObject eContainer;
        Namespace context = this.constraint.getContext();
        EClassifier eClassifier = (EClassifier)this.ocl.getMetaModelManager().getEcoreOfPivot(EClass.class, (Element)context);
        boolean result = false;
        if (eClassifier != null && !result && (eContainer = eClassifier.eContainer()) instanceof EPackage) {
            String nsURI = ((EPackage)eContainer).getNsURI();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            EClassifier eClassifier2 = ePackage.getEClassifier(eClassifier.getName());
            result = eClassifier2.isInstance((Object)object);
        }
        return result;
    }

    public boolean targetsEvent(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            return this.targetsTypeOf((EObject)notifier);
        }
        return false;
    }

    public int getStatusCode() {
        return 0;
    }

    public ConstraintSeverity getSeverity() {
        return ConstraintSeverity.ERROR;
    }

    public String getPluginId() {
        return "org.polarsys.reqcycle.utils.ocl.validation";
    }

    public String getName() {
        return this.constraint.getName();
    }

    public String getMessagePattern() {
        return "{0}";
    }

    public String getId() {
        Resource eResource = this.constraint.eResource();
        return String.valueOf(eResource.getURI().lastSegment()) + "#" + this.constraint.getName();
    }

    public EvaluationMode<?> getEvaluationMode() {
        return EvaluationMode.LIVE;
    }

    public String getDescription() {
        return null;
    }

    public String getBody() {
        return null;
    }
}

