/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.emf.handlers;

import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.emf.handlers.IEMFProxyRegistry;
import org.polarsys.reqcycle.emf.ui.EMFLabelProvider;
import org.polarsys.reqcycle.emf.utils.EMFUtils;
import org.polarsys.reqcycle.emf.visitors.EMFVisitable;
import org.polarsys.reqcycle.uri.Activator;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.model.IBusinessObject;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.IVisitable;

public class EMFReachableObject
implements ReachableObject {
    private final Reachable t;
    @Inject
    ILogger logger;
    @Inject
    IEMFProxyRegistry registry;

    public EMFReachableObject(Reachable t) {
        this.t = t;
    }

    public IVisitable getVisitable() throws VisitableException {
        try {
            EMFVisitable emfVisitable = this.doGetVisitable(EMFUtils.getEMFURI(this.t));
            return emfVisitable;
        }
        catch (RuntimeException runtimeException) {
            if (Activator.getDefault().isDebugging()) {
                this.logger.trace("Error loading " + this.t.toString());
            }
            throw new VisitableException();
        }
    }

    protected EMFVisitable doGetVisitable(URI uri) {
        return new EMFVisitable(uri);
    }

    public String getRevisionIdentification() {
        try {
            EMFVisitable emfVisitable = (EMFVisitable)this.getVisitable();
            String result = emfVisitable.getResourceTimeStamp();
            emfVisitable.dispose();
            return result;
        }
        catch (VisitableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        IFile f;
        Resource r;
        if (IBusinessObject.class.equals((Object)adapter)) {
            URI createURI = URI.createURI((String)this.t.toString());
            if (createURI.isPlatformResource()) {
                return new IBusinessObject.DefaultBusinessObject(!this.registry.isProxy(createURI));
            }
            EObject obj = (EObject)this.getAdapter(EObject.class);
            return new IBusinessObject.DefaultBusinessObject(obj != null && !obj.eIsProxy());
        }
        if (EObject.class.equals((Object)adapter) && this.t.getFragment() != null && this.t.getFragment().length() > 0 && (r = (Resource)this.getAdapter(Resource.class)) != null) {
            return r.getEObject(this.t.getFragment());
        }
        if (IMarker.class.equals((Object)adapter) && (f = (IFile)this.getAdapter(IFile.class)) != null) {
            IMarker marker = new IMarker(){

                public Object getAdapter(Class adapter) {
                    return null;
                }

                public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
                }

                public void setAttributes(Map<String, ? extends Object> attributes) throws CoreException {
                }

                public void setAttribute(String attributeName, boolean value) throws CoreException {
                }

                public void setAttribute(String attributeName, Object value) throws CoreException {
                }

                public void setAttribute(String attributeName, int value) throws CoreException {
                }

                public boolean isSubtypeOf(String superType) throws CoreException {
                    return true;
                }

                public String getType() throws CoreException {
                    return "org.eclipse.emf.ecore.diagnostic";
                }

                public IResource getResource() {
                    return f;
                }

                public long getId() {
                    return 0L;
                }

                public long getCreationTime() throws CoreException {
                    return 0L;
                }

                public Object[] getAttributes(String[] attributeNames) throws CoreException {
                    return new Object[0];
                }

                public Map<String, Object> getAttributes() throws CoreException {
                    return Collections.emptyMap();
                }

                public boolean getAttribute(String attributeName, boolean defaultValue) {
                    return false;
                }

                public String getAttribute(String attributeName, String defaultValue) {
                    if ("uri".equals(attributeName)) {
                        return EMFReachableObject.this.t.toString();
                    }
                    return null;
                }

                public int getAttribute(String attributeName, int defaultValue) {
                    return 0;
                }

                public Object getAttribute(String attributeName) throws CoreException {
                    if ("uri".equals(attributeName)) {
                        return EMFReachableObject.this.t.toString();
                    }
                    return null;
                }

                public boolean exists() {
                    return true;
                }

                public void delete() throws CoreException {
                }
            };
            return marker;
        }
        if (IResource.class.equals((Object)adapter) || IFile.class.equals((Object)adapter)) {
            try {
                return WorkspaceSynchronizer.getFile((Resource)((EMFVisitable)this.getVisitable()).getResource());
            }
            catch (VisitableException e) {
                e.printStackTrace();
            }
        }
        if (Resource.class.equals((Object)adapter)) {
            try {
                return ((EMFVisitable)this.getVisitable()).getResource();
            }
            catch (VisitableException e) {
                e.printStackTrace();
            }
        }
        if (IVisitable.class.equals((Object)adapter)) {
            try {
                return this.getVisitable();
            }
            catch (VisitableException e) {
                e.printStackTrace();
            }
        }
        if (ILabelProvider.class.equals((Object)adapter)) {
            return new EMFLabelProvider();
        }
        return null;
    }

    public Reachable getReachable() {
        return this.t;
    }
}

