/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.model;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.model.Reachable;

public class Link {
    Set<Reachable> sources = new HashSet<Reachable>();
    Set<Reachable> targets = new HashSet<Reachable>();
    TType kind;
    Reachable id;

    public Link(Reachable id, TType kind, Iterable<Reachable> sources, Iterable<Reachable> targets) {
        this.id = id;
        this.kind = kind;
        this.sources = Sets.newHashSet(sources);
        this.targets = Sets.newHashSet(targets);
    }

    public Link(Reachable id, TType kind, Reachable source, Reachable target) {
        this(id, kind, Collections.singleton(source), Collections.singleton(target));
    }

    public Reachable getId() {
        return this.id;
    }

    public String getLabel() {
        String label = this.kind.getLabel();
        if (this.kind.getSuperType() != null) {
            label = String.valueOf(label) + " [" + this.kind.getSuperType().getLabel() + "]";
        }
        return label;
    }

    public TType getKind() {
        return this.kind;
    }

    public Set<Reachable> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    public Set<Reachable> getTargets() {
        return Collections.unmodifiableSet(this.targets);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link link = (Link)obj;
            return Objects.equal(this.sources, link.sources) && Objects.equal(this.targets, link.targets) && Objects.equal((Object)this.kind, (Object)link.kind);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sources, this.targets, this.kind});
    }
}

