/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class BuilderUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBuilderInstalled(IProject project) {
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            int i = 0;
            while (true) {
                if (i >= commands.length) {
                    return false;
                }
                if (commands[i].getBuilderName().equals("org.polarsys.reqcycle.traceability.builder")) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static void installBuilder(IProject project) {
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.polarsys.reqcycle.traceability.builder");
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[commands.length] = command;
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, null);
        }
        catch (CoreException coreException) {}
    }

    public static void removeBuilder(IProject project) {
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ICommand[] newCommands = new ICommand[commands.length - 1];
            int i = 0;
            int j = 0;
            while (i < commands.length) {
                if (!commands[i].getBuilderName().equals("org.polarsys.reqcycle.traceability.builder")) {
                    newCommands[j] = commands[i];
                    ++j;
                }
                ++i;
            }
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, null);
        }
        catch (CoreException coreException) {}
    }
}

