/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.reqcycle.repository.connector.ConnectorDescriptor;
import org.polarsys.reqcycle.repository.connector.IConnectorManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

@Singleton
public class ConnectorManager
implements IConnectorManager {
    private Map<String, ConnectorDescriptor> connectors = new HashMap<String, ConnectorDescriptor>();

    ConnectorManager() {
        IConfigurationElement[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor("org.polarsys.reqcycle.repository.connector", "connectorCore");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String name = iConfigurationElement.getAttribute("name");
            String id = iConfigurationElement.getAttribute("id");
            String icon = iConfigurationElement.getAttribute("icon");
            ImageDescriptor imageDescriptor = null;
            if (icon != null && !icon.isEmpty()) {
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)iConfigurationElement.getNamespaceIdentifier(), (String)icon);
            }
            ConnectorDescriptor repositoryConnectorDescriptor = new ConnectorDescriptor(iConfigurationElement, name, id, imageDescriptor);
            ZigguratInject.inject((Object[])new Object[]{repositoryConnectorDescriptor});
            this.addConnector(repositoryConnectorDescriptor, id);
            ++n2;
        }
    }

    protected void addConnector(ConnectorDescriptor connectorDescriptor, String connectorID) {
        if (!this.connectors.values().contains(connectorDescriptor)) {
            this.connectors.put(connectorID, connectorDescriptor);
        }
    }

    @Override
    public Collection<ConnectorDescriptor> getAllConnectors() {
        return this.connectors.values();
    }

    @Override
    public ConnectorDescriptor get(String connectorId) {
        return this.connectors.get(connectorId);
    }
}

