/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.statushandler.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.statushandler.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.statushandler.internal.StatusHandlerBinding;
import org.osgi.framework.Bundle;

public class StatusHandlerBindingExtensionPointManager
extends AbstractExtensionPointManager<StatusHandlerBinding> {
    StatusHandlerBindingExtensionPointManager() {
    }

    public static StatusHandlerBindingExtensionPointManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.runtime.statushandler.bindings";
    }

    protected String getConfigurationElementName() {
        return "binding";
    }

    protected ExecutableExtensionProxy<StatusHandlerBinding> doCreateExtensionProxy(IConfigurationElement element) throws CoreException {
        return new ExecutableExtensionProxy<StatusHandlerBinding>(element){

            public StatusHandlerBinding newInstance() {
                StatusHandlerBinding instance = new StatusHandlerBinding();
                try {
                    instance.setInitializationData(this.getConfigurationElement(), null, null);
                }
                catch (CoreException e) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
                return instance;
            }
        };
    }

    public StatusHandlerBinding[] getApplicableBindings(Object context) {
        ArrayList<StatusHandlerBinding> applicable = new ArrayList<StatusHandlerBinding>();
        StatusHandlerBinding[] statusHandlerBindingArray = this.getBindings();
        int n = statusHandlerBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isApplicable;
            StatusHandlerBinding binding = statusHandlerBindingArray[n2];
            Expression enablement = binding.getEnablement();
            boolean bl = isApplicable = enablement == null;
            if (enablement != null) {
                if (context != null) {
                    EvaluationContext evalContext = new EvaluationContext(null, context);
                    evalContext.addVariable("context", context);
                    evalContext.setAllowPluginActivation(true);
                    try {
                        isApplicable = enablement.evaluate((IEvaluationContext)evalContext).equals(EvaluationResult.TRUE);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                    }
                } else {
                    isApplicable = false;
                }
            }
            if (isApplicable) {
                applicable.add(binding);
            }
            ++n2;
        }
        return applicable.toArray(new StatusHandlerBinding[applicable.size()]);
    }

    public StatusHandlerBinding[] getBindings() {
        ArrayList<StatusHandlerBinding> contributions = new ArrayList<StatusHandlerBinding>();
        Collection statusHandlerBindings = this.getExtensions().values();
        for (ExecutableExtensionProxy statusHandlerBinding : statusHandlerBindings) {
            StatusHandlerBinding instance = (StatusHandlerBinding)((Object)statusHandlerBinding.getInstance());
            if (instance == null || contributions.contains((Object)instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new StatusHandlerBinding[contributions.size()]);
    }

    private static class LazyInstance {
        public static StatusHandlerBindingExtensionPointManager instance = new StatusHandlerBindingExtensionPointManager();

        private LazyInstance() {
        }
    }
}

