/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EvaluationContextManager
implements IWindowListener,
IDebugContextListener {
    private static EvaluationContextManager fgManager;
    private static final String DEBUGGER_ACTIVE = "org.eclipse.php.debug.ui.debuggerActive";
    private Map<IWorkbenchPage, IStackFrame> fContextsByPage = null;
    private IWorkbenchWindow fActiveWindow;

    private EvaluationContextManager() {
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public static void startup() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (fgManager == null) {
                    fgManager = new EvaluationContextManager(null);
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        fgManager.windowOpened(windows[i]);
                        ++i;
                    }
                    workbench.addWindowListener((IWindowListener)fgManager);
                    fgManager.fActiveWindow = workbench.getActiveWorkbenchWindow();
                }
            }
        };
        PHPDebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.fActiveWindow = window;
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    private void setContext(IWorkbenchPage page, IStackFrame frame, boolean instOf) {
        if (this.fContextsByPage == null) {
            this.fContextsByPage = new HashMap<IWorkbenchPage, IStackFrame>();
        }
        this.fContextsByPage.put(page, frame);
        System.setProperty(DEBUGGER_ACTIVE, "true");
    }

    private void removeContext(IWorkbenchPage page) {
        if (this.fContextsByPage != null) {
            this.fContextsByPage.remove(page);
        }
    }

    public static IStackFrame getEvaluationContext(IWorkbenchPart part) {
        IWorkbenchPage page = part.getSite().getPage();
        IStackFrame frame = EvaluationContextManager.getContext(page);
        if (frame == null) {
            return EvaluationContextManager.getEvaluationContext(page.getWorkbenchWindow());
        }
        return frame;
    }

    private static IStackFrame getContext(IWorkbenchPage page) {
        if (fgManager != null && EvaluationContextManager.fgManager.fContextsByPage != null) {
            return EvaluationContextManager.fgManager.fContextsByPage.get(page);
        }
        return null;
    }

    public static IStackFrame getEvaluationContext(IWorkbenchWindow window) {
        ArrayList<IWorkbenchWindow> alreadyVisited = new ArrayList<IWorkbenchWindow>();
        if (window == null) {
            window = EvaluationContextManager.fgManager.fActiveWindow;
        }
        return EvaluationContextManager.getEvaluationContext(window, alreadyVisited);
    }

    private static IStackFrame getEvaluationContext(IWorkbenchWindow window, List<IWorkbenchWindow> alreadyVisited) {
        IWorkbenchPage activePage = window.getActivePage();
        IStackFrame frame = null;
        if (activePage != null) {
            frame = EvaluationContextManager.getContext(activePage);
        }
        if (frame == null) {
            IWorkbenchPage[] pages = window.getPages();
            int i = 0;
            while (i < pages.length) {
                if (activePage != pages[i] && (frame = EvaluationContextManager.getContext(pages[i])) != null) {
                    return frame;
                }
                ++i;
            }
            alreadyVisited.add(window);
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i2 = 0;
            while (i2 < windows.length) {
                if (!alreadyVisited.contains(windows[i2]) && (frame = EvaluationContextManager.getEvaluationContext(windows[i2], alreadyVisited)) != null) {
                    return frame;
                }
                ++i2;
            }
            return null;
        }
        return frame;
    }

    public void debugContextChanged(DebugContextEvent event) {
        IWorkbenchPart part;
        if ((event.getFlags() & 1) > 0 && (part = event.getDebugContextProvider().getPart()) != null) {
            Object element;
            IStructuredSelection ss;
            IWorkbenchPage page = part.getSite().getPage();
            ISelection selection = event.getContext();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
                boolean instOf;
                IStackFrame frame = (IStackFrame)((IAdaptable)element).getAdapter(IStackFrame.class);
                boolean bl = instOf = element instanceof IStackFrame || element instanceof IThread;
                if (frame != null) {
                    this.setContext(page, frame, instOf);
                    return;
                }
            }
            this.removeContext(page);
        }
    }

    /* synthetic */ EvaluationContextManager(EvaluationContextManager evaluationContextManager) {
        this();
    }
}

