/*******************************************************************************
 * Copyright (c) 2009, 2018 Willink Transformations and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.ecore.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import org.eclipse.ocl.ecore.CallExp;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.EcorePackage;

import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.ExpressionsPackage;

import org.eclipse.ocl.utilities.UtilitiesPackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.ocl.ecore.CallExp} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class CallExpItemProvider
		extends OCLExpressionItemProvider {

	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CallExpItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addPropertyStartPositionPropertyDescriptor(object);
			addPropertyEndPositionPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Property Start Position feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addPropertyStartPositionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(),
			getString("_UI_CallingASTNode_propertyStartPosition_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_CallingASTNode_propertyStartPosition_feature", //$NON-NLS-1$
				"_UI_CallingASTNode_type"), //$NON-NLS-1$
			UtilitiesPackage.Literals.CALLING_AST_NODE__PROPERTY_START_POSITION,
			true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
			null, null));
	}

	/**
	 * This adds a property descriptor for the Property End Position feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addPropertyEndPositionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
			((ComposeableAdapterFactory) adapterFactory)
				.getRootAdapterFactory(),
			getResourceLocator(),
			getString("_UI_CallingASTNode_propertyEndPosition_feature"), //$NON-NLS-1$
			getString("_UI_PropertyDescriptor_description", //$NON-NLS-1$
				"_UI_CallingASTNode_propertyEndPosition_feature", //$NON-NLS-1$
				"_UI_CallingASTNode_type"), //$NON-NLS-1$
			UtilitiesPackage.Literals.CALLING_AST_NODE__PROPERTY_END_POSITION,
			true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
			null, null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(
			Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(ExpressionsPackage.Literals.CALL_EXP__SOURCE);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean shouldComposeCreationImage() {
		return true;
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((CallExp) object).getName();
		return label == null || label.length() == 0
			? getString("_UI_CallExp_type") //$NON-NLS-1$
			: getString("_UI_CallExp_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(CallExp.class)) {
			case EcorePackage.CALL_EXP__PROPERTY_START_POSITION :
			case EcorePackage.CALL_EXP__PROPERTY_END_POSITION :
				fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), false, true));
				return;
			case EcorePackage.CALL_EXP__SOURCE :
				fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createAssociationClassCallExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createBooleanLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createCollectionLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createEnumLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createIfExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createIntegerLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createUnlimitedNaturalLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createInvalidLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createIterateExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createIteratorExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createLetExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createMessageExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createNullLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createOperationCallExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createPropertyCallExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createRealLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createStateExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createStringLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createTupleLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createTypeExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createUnspecifiedValueExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createVariableExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				EcoreFactory.eINSTANCE.createOppositePropertyCallExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createAssociationClassCallExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createBooleanLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createCollectionLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createEnumLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createIfExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createIntegerLiteralExp()));

		newChildDescriptors.add(createChildParameter(
			ExpressionsPackage.Literals.CALL_EXP__SOURCE,
			ExpressionsFactory.eINSTANCE.createUnlimitedNaturalLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createInvalidLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createIterateExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createIteratorExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createLetExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createMessageExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createNullLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createOperationCallExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createPropertyCallExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createRealLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createStateExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createStringLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createTupleLiteralExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createTypeExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createUnspecifiedValueExp()));

		newChildDescriptors.add(
			createChildParameter(ExpressionsPackage.Literals.CALL_EXP__SOURCE,
				ExpressionsFactory.eINSTANCE.createVariableExp()));
	}

}
