/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.ConfigurationResourceListener;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat32Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat40Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat41Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat50Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat55Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat60Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat70Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat80Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat85Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat90Handler;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.VerifyResourceSpec;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatPlugin
extends Plugin {
    protected static TomcatPlugin singleton;
    public static final String PLUGIN_ID = "org.eclipse.jst.server.tomcat.core";
    public static final String TOMCAT_32 = "org.eclipse.jst.server.tomcat.32";
    public static final String TOMCAT_40 = "org.eclipse.jst.server.tomcat.40";
    public static final String TOMCAT_41 = "org.eclipse.jst.server.tomcat.41";
    public static final String TOMCAT_50 = "org.eclipse.jst.server.tomcat.50";
    public static final String TOMCAT_55 = "org.eclipse.jst.server.tomcat.55";
    public static final String TOMCAT_60 = "org.eclipse.jst.server.tomcat.60";
    public static final String TOMCAT_70 = "org.eclipse.jst.server.tomcat.70";
    public static final String TOMCAT_80 = "org.eclipse.jst.server.tomcat.80";
    public static final String TOMCAT_85 = "org.eclipse.jst.server.tomcat.85";
    public static final String TOMCAT_90 = "org.eclipse.jst.server.tomcat.90";
    protected static final String VERIFY_INSTALL_FILE = "verifyInstall.properties";
    protected static VerifyResourceSpec[] verify32;
    protected static VerifyResourceSpec[] verify40;
    protected static VerifyResourceSpec[] verify41;
    protected static VerifyResourceSpec[] verify50;
    protected static VerifyResourceSpec[] verify55;
    protected static VerifyResourceSpec[] verify60;
    protected static VerifyResourceSpec[] verify70;
    protected static VerifyResourceSpec[] verify80;
    protected static final IStatus emptyInstallDirStatus;
    protected static final IStatus wrongDirVersionStatus;
    protected static final IStatus installDirDoesNotExist;
    private static ConfigurationResourceListener configurationListener;

    static {
        emptyInstallDirStatus = new Status(4, PLUGIN_ID, 0, Messages.errorInstallDirEmpty, null);
        wrongDirVersionStatus = new Status(4, PLUGIN_ID, 0, Messages.errorInstallDirWrongVersion, null);
        installDirDoesNotExist = new Status(4, PLUGIN_ID, 0, Messages.errorInstallDirDoesNotExist, null);
    }

    public TomcatPlugin() {
        singleton = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        configurationListener = new ConfigurationResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)configurationListener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)configurationListener);
        super.stop(context);
    }

    public static TomcatPlugin getInstance() {
        return singleton;
    }

    public static String getPreference(String id) {
        return TomcatPlugin.getInstance().getPluginPreferences().getString(id);
    }

    public static void setPreference(String id, String value) {
        TomcatPlugin.getInstance().getPluginPreferences().setValue(id, value);
        TomcatPlugin.getInstance().savePluginPreferences();
    }

    public static void log(IStatus status) {
        TomcatPlugin.getInstance().getLog().log(status);
    }

    protected static String getTomcatStateLocation() {
        try {
            return TomcatPlugin.getInstance().getStateLocation().toOSString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ITomcatVersionHandler getTomcatVersionHandler(String id) {
        if (id.indexOf("runtime") > 0) {
            id = String.valueOf(id.substring(0, 30)) + id.substring(38);
        }
        if (TOMCAT_32.equals(id)) {
            return new Tomcat32Handler();
        }
        if (TOMCAT_40.equals(id)) {
            return new Tomcat40Handler();
        }
        if (TOMCAT_41.equals(id)) {
            return new Tomcat41Handler();
        }
        if (TOMCAT_50.equals(id)) {
            return new Tomcat50Handler();
        }
        if (TOMCAT_55.equals(id)) {
            return new Tomcat55Handler();
        }
        if (TOMCAT_60.equals(id)) {
            return new Tomcat60Handler();
        }
        if (TOMCAT_70.equals(id)) {
            return new Tomcat70Handler();
        }
        if (TOMCAT_80.equals(id)) {
            return new Tomcat80Handler();
        }
        if (TOMCAT_85.equals(id)) {
            return new Tomcat85Handler();
        }
        if (TOMCAT_90.equals(id)) {
            return new Tomcat90Handler();
        }
        return null;
    }

    public static void loadVerifyFiles() {
        if (verify32 != null) {
            return;
        }
        verify32 = new VerifyResourceSpec[0];
        verify40 = new VerifyResourceSpec[0];
        verify41 = new VerifyResourceSpec[0];
        verify50 = new VerifyResourceSpec[0];
        verify55 = new VerifyResourceSpec[0];
        verify60 = new VerifyResourceSpec[0];
        verify70 = new VerifyResourceSpec[0];
        verify80 = new VerifyResourceSpec[0];
        try {
            URL url = TomcatPlugin.getInstance().getBundle().getEntry(VERIFY_INSTALL_FILE);
            url = FileLocator.resolve((URL)url);
            Properties p = new Properties();
            p.load(url.openStream());
            List<VerifyResourceSpec> list = TomcatPlugin.loadVerifyResourceSpecs("verify32install", p);
            verify32 = new VerifyResourceSpec[list.size()];
            list.toArray(verify32);
            list = TomcatPlugin.loadVerifyResourceSpecs("verify40install", p);
            verify40 = new VerifyResourceSpec[list.size()];
            list.toArray(verify40);
            list = TomcatPlugin.loadVerifyResourceSpecs("verify41install", p);
            verify41 = new VerifyResourceSpec[list.size()];
            list.toArray(verify41);
            list = TomcatPlugin.loadVerifyResourceSpecs("verify50install", p);
            verify50 = new VerifyResourceSpec[list.size()];
            list.toArray(verify50);
            list = TomcatPlugin.loadVerifyResourceSpecs("verify55install", p);
            verify55 = new VerifyResourceSpec[list.size()];
            list.toArray(verify55);
            list = TomcatPlugin.loadVerifyResourceSpecs("verify60install", p);
            verify60 = new VerifyResourceSpec[list.size()];
            list.toArray(verify60);
            list = TomcatPlugin.loadVerifyResourceSpecs("verify70install", p);
            verify70 = new VerifyResourceSpec[list.size()];
            list.toArray(verify70);
            list = TomcatPlugin.loadVerifyResourceSpecs("verify80install", p);
            verify80 = new VerifyResourceSpec[list.size()];
            list.toArray(verify80);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not load installation verification properties", e);
        }
    }

    public static List<VerifyResourceSpec> loadVerifyResourceSpecs(String propName, Properties defaultVerifyProperties) {
        String verify = System.getProperty("org.eclipse.jst.server.tomcat.core." + propName);
        if (verify == null) {
            verify = defaultVerifyProperties.getProperty(propName);
        }
        verify.replace('/', File.separatorChar);
        StringTokenizer st = new StringTokenizer(verify, ",");
        ArrayList<VerifyResourceSpec> list = new ArrayList<VerifyResourceSpec>();
        while (st.hasMoreTokens()) {
            list.add(new VerifyResourceSpec(st.nextToken()));
        }
        Trace.trace((byte)3, String.valueOf(propName) + ": " + ((Object)list).toString());
        return list;
    }

    public static IStatus verifyInstallPathWithFolderCheck(IPath installPath, String id) {
        IStatus status = TomcatPlugin.verifyTomcatVersionFromPath(installPath, id);
        if (status.isOK()) {
            status = TomcatPlugin.verifyInstallPath(installPath, id);
        }
        return status;
    }

    public static IStatus verifyInstallPath(IPath installPath, String id) {
        if (installPath == null) {
            return emptyInstallDirStatus;
        }
        String dir = installPath.toOSString();
        if (dir.trim().length() == 0) {
            return emptyInstallDirStatus;
        }
        File file = new File(dir);
        if (!file.exists()) {
            return installDirDoesNotExist;
        }
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        TomcatPlugin.loadVerifyFiles();
        VerifyResourceSpec[] specs = null;
        if (TOMCAT_32.equals(id)) {
            specs = verify32;
        } else if (TOMCAT_40.equals(id)) {
            specs = verify40;
        } else if (TOMCAT_41.equals(id)) {
            specs = verify41;
        } else if (TOMCAT_50.equals(id)) {
            specs = verify50;
        } else if (TOMCAT_55.equals(id)) {
            specs = verify55;
        } else if (TOMCAT_60.equals(id)) {
            specs = verify60;
        } else {
            return new Status(4, PLUGIN_ID, 0, Messages.errorUnknownVersion, null);
        }
        int i = 0;
        while (i < specs.length) {
            VerifyResourceSpec fs = specs[i];
            IStatus status = fs.checkResource(dir);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public static IStatus verifyTomcatVersionFromPath(IPath installPath, String version) {
        if (version == null) {
            return new Status(4, PLUGIN_ID, 0, Messages.errorVersionEmpty, null);
        }
        if (installPath == null) {
            return emptyInstallDirStatus;
        }
        String s = installPath.lastSegment();
        if (s == null) {
            return Status.OK_STATUS;
        }
        if (s.indexOf("-3.2") > 0 || s.indexOf(" 3.2") > 0) {
            return TOMCAT_32.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-4.0") > 0 || s.indexOf(" 4.0") > 0) {
            return TOMCAT_40.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-4.1") > 0 || s.indexOf(" 4.1") > 0) {
            return TOMCAT_41.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-5.0") > 0 || s.indexOf(" 5.0") > 0) {
            return TOMCAT_50.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-5.5") > 0 || s.indexOf(" 5.5") > 0) {
            return TOMCAT_55.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        if (s.indexOf("-6.0") > 0 || s.indexOf(" 6.0") > 0) {
            return TOMCAT_60.equals(version) ? Status.OK_STATUS : wrongDirVersionStatus;
        }
        return Status.OK_STATUS;
    }

    protected static File getPlugin() {
        try {
            URL installURL = TomcatPlugin.getInstance().getBundle().getEntry("/");
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void log(String message) {
        TomcatPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void log(Throwable e) {
        TomcatPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, e.getMessage(), e));
    }
}

