/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.composite;

import com.google.inject.Inject;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.parsley.composite.FormDetailComposite;
import org.eclipse.emf.parsley.composite.FormFactory;
import org.eclipse.emf.parsley.util.EmfSelectionHelper;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractMasterDetailComposite
extends Composite
implements IViewerProvider {
    private FormFactory formFactory;
    private EmfSelectionHelper emfSelectionHelper;
    private final StructuredViewer viewer;
    private final Composite detailComposite;
    private FormDetailComposite detailForm;
    private SashForm sashForm;

    public AbstractMasterDetailComposite(Composite parent, int style) {
        this(parent, style, 512, new int[0]);
    }

    public AbstractMasterDetailComposite(Composite parent, int style, int sashStyle, int[] weights) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.sashForm = new SashForm((Composite)this, sashStyle);
        Composite masterComposite = new Composite((Composite)this.sashForm, 0);
        masterComposite.setLayout((Layout)new FillLayout());
        this.detailComposite = new Composite((Composite)this.sashForm, 0);
        this.detailComposite.setLayout((Layout)new FillLayout());
        this.viewer = this.createViewer(masterComposite);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListener());
        if (weights.length > 0) {
            this.sashForm.setWeights(weights);
        }
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    protected void eObjectSelectionChanged(EObject selectedObject) {
        if (this.detailForm != null) {
            this.detailForm.dispose();
        }
        if (selectedObject != null) {
            this.detailForm = this.createFormDetailComposite();
            this.detailForm.init(selectedObject);
            this.detailComposite.layout(true);
        }
    }

    protected FormDetailComposite createFormDetailComposite() {
        return this.getFormFactory().createFormDetailComposite(this.detailComposite, 2048);
    }

    public FormFactory getFormFactory() {
        return this.formFactory;
    }

    @Inject
    public void setFormFactory(FormFactory formFactory) {
        this.formFactory = formFactory;
    }

    public EmfSelectionHelper getEmfSelectionHelper() {
        return this.emfSelectionHelper;
    }

    @Inject
    public void setEmfSelectionHelper(EmfSelectionHelper emfSelectionHelper) {
        this.emfSelectionHelper = emfSelectionHelper;
    }

    public SashForm getSashForm() {
        return this.sashForm;
    }

    public abstract void update(Object var1);

    protected class SelectionChangedListener
    implements ISelectionChangedListener {
        protected SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            EObject selectedObject = AbstractMasterDetailComposite.this.getEmfSelectionHelper().getFirstSelectedEObject(event.getSelection());
            AbstractMasterDetailComposite.this.eObjectSelectionChanged(selectedObject);
        }
    }
}

