/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.extended.initializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.eef.EEFGen.EEFGenFactory;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.EEFGen.GenEditionContext;
import org.eclipse.emf.eef.EEFGen.GenViewsRepository;
import org.eclipse.emf.eef.codegen.core.initializer.AbstractPropertiesInitializer;
import org.eclipse.emf.eef.codegen.core.util.EMFHelper;
import org.eclipse.emf.eef.codegen.extended.initializer.EEFEditorContributionTransformer;
import org.eclipse.emf.eef.codegen.extended.initializer.EEFPagesTransformer;
import org.eclipse.emf.eef.codegen.flow.util.GenmodelHelper;
import org.eclipse.emf.eef.components.PropertiesEditionContext;
import org.eclipse.emf.eef.views.ViewsRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEFEditorModelInitializer
extends AbstractPropertiesInitializer {
    public void initialize(URI modelURI, IContainer targetFolder) throws IOException, CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.registerResourceFactories((ResourceSet)resourceSet);
        this.registerPackages((ResourceSet)resourceSet);
        EObject model = EMFHelper.load((URI)modelURI, (ResourceSet)resourceSet);
        if (!targetFolder.exists()) {
            if (targetFolder instanceof IFolder) {
                ((IFolder)targetFolder).create(true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                return;
            }
        }
        EEFPagesTransformer pagesTransformer = new EEFPagesTransformer();
        TreeIterator allContents = model.eAllContents();
        HashMap<ViewsRepository, String> repositories = new HashMap<ViewsRepository, String>();
        ArrayList<PropertiesEditionContext> contexts = new ArrayList<PropertiesEditionContext>();
        while (allContents.hasNext()) {
            GenPackage genPack;
            EObject next = (EObject)allContents.next();
            if (!(next instanceof GenPackage) || (genPack = (GenPackage)next).eContents().size() < 1) continue;
            ViewsRepository repository = pagesTransformer.genPackage2ViewsRepository(genPack);
            Object completePackage = genPack.getBasePackage();
            completePackage = completePackage != null && ((String)completePackage).length() > 0 ? String.valueOf(completePackage) + "." + this.ecoreStringHierarchy(genPack) : this.ecoreStringHierarchy(genPack);
            repositories.put(repository, (String)completePackage);
            EEFEditorContributionTransformer contributionTransformer = new EEFEditorContributionTransformer(pagesTransformer.getWorkingResolvTemp());
            PropertiesEditionContext context = contributionTransformer.genPackage2Context(genPack);
            contexts.add(context);
        }
        URI contributionsModelUri = GenmodelHelper.computeEditorComponentsModelURI((IContainer)targetFolder, (URI)model.eResource().getURI());
        Resource contributionsResource = model.eResource().getResourceSet().createResource(contributionsModelUri);
        for (PropertiesEditionContext context : contexts) {
            contributionsResource.getContents().add((Object)context);
        }
        for (ViewsRepository repository : repositories.keySet()) {
            contributionsResource.getContents().add((Object)repository);
        }
        EEFGenModel eefGenModel = this.createEEFGenModel((GenModel)model, repositories, contexts, targetFolder);
        contributionsResource.save(Collections.EMPTY_MAP);
        URI eefgenModelUri = GenmodelHelper.computeEditorEEFGenModelURI((IContainer)targetFolder, (URI)model.eResource().getURI());
        Resource eefgenResource = model.eResource().getResourceSet().createResource(eefgenModelUri);
        eefgenResource.getContents().add((Object)eefGenModel);
        eefgenResource.save(Collections.EMPTY_MAP);
    }

    public String ecoreStringHierarchy(GenPackage genPack) {
        String result = "";
        List<EPackage> ecorePackageHierarchy = this.ecorePackageHierarchy(genPack);
        int i = ecorePackageHierarchy.size() - 1;
        while (i >= 0) {
            EPackage next = ecorePackageHierarchy.get(i);
            result = String.valueOf(result) + next.getName();
            if (i > 0) {
                result = String.valueOf(result) + ".";
            }
            --i;
        }
        return genPack.getEcorePackage().getName();
    }

    public List<EPackage> ecorePackageHierarchy(GenPackage genPack) {
        ArrayList<EPackage> hierarchy = new ArrayList<EPackage>();
        EPackage current = genPack.getEcorePackage();
        while (current instanceof EPackage) {
            hierarchy.add(current);
            current = current.eContainer();
        }
        return hierarchy;
    }

    private EEFGenModel createEEFGenModel(GenModel inputGenmodel, Map<ViewsRepository, String> repositories, List<PropertiesEditionContext> contexts, IContainer targetFolder) {
        EEFGenModel eefGenModel = EEFGenFactory.eINSTANCE.createEEFGenModel();
        eefGenModel.setGenDirectory(this.findGenDirectory(inputGenmodel));
        for (PropertiesEditionContext context : contexts) {
            eefGenModel.getEditionContexts().add((Object)this.createGenEditionContext(context));
        }
        String contextPackage = "";
        if (contexts.size() > 0) {
            String findBasePackage = this.findBasePackage(contexts.get(0).getModel());
            if (findBasePackage != null && !findBasePackage.equals("")) {
                contextPackage = String.valueOf(findBasePackage) + ".";
            }
            contextPackage = String.valueOf(contextPackage) + contexts.get(0).getModel().getEcorePackage().getName().toLowerCase();
        }
        for (ViewsRepository repository : repositories.keySet()) {
            eefGenModel.getViewsRepositories().add((Object)this.createGenViewsRepository(repository, repositories.get(repository)));
        }
        return eefGenModel;
    }

    private GenEditionContext createGenEditionContext(PropertiesEditionContext context) {
        GenEditionContext genEditionContext = EEFGenFactory.eINSTANCE.createGenEditionContext();
        genEditionContext.setPropertiesEditionContext(context);
        if (context.getModel() != null) {
            genEditionContext.setBasePackage(this.findBasePackage(context.getModel()));
        }
        genEditionContext.setDescriptorsGenericPropertiesViews(true);
        return genEditionContext;
    }

    private GenViewsRepository createGenViewsRepository(ViewsRepository repository, String contextPackage) {
        GenViewsRepository genViewsRepository = EEFGenFactory.eINSTANCE.createGenViewsRepository();
        genViewsRepository.setViewsRepository(repository);
        genViewsRepository.setBasePackage(contextPackage);
        genViewsRepository.setSwtViews(true);
        genViewsRepository.setFormViews(true);
        return genViewsRepository;
    }

    private String findBasePackage(GenPackage genPackage) {
        if (genPackage.getBasePackage() != null) {
            return genPackage.getBasePackage();
        }
        return "";
    }

    private String findGenDirectory(GenModel genmodel) {
        return genmodel.getEditorDirectory();
    }
}

