/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.msw.build;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.envvar.IProjectEnvironmentVariableSupplier;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WinEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier,
IProjectEnvironmentVariableSupplier {
    private static Map<String, IBuildEnvironmentVariable> envvars;
    private static String sdkDir;
    private static String vcDir;

    public WinEnvironmentVariableSupplier() {
        WinEnvironmentVariableSupplier.initvars();
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IManagedProject project, IEnvironmentVariableProvider provider) {
        return envvars.get(variableName);
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        return envvars.get(variableName);
    }

    public IBuildEnvironmentVariable[] getVariables(IManagedProject project, IEnvironmentVariableProvider provider) {
        return envvars.values().toArray(new IBuildEnvironmentVariable[envvars.size()]);
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        return envvars.values().toArray(new IBuildEnvironmentVariable[envvars.size()]);
    }

    private static String getSoftwareKey(WindowsRegistry reg, String subkey, String name) {
        String value = reg.getLocalMachineValue("SOFTWARE\\" + subkey, name);
        if (value == null) {
            value = reg.getLocalMachineValue("SOFTWARE\\Wow6432Node\\" + subkey, name);
        }
        return value;
    }

    private static String getSDKDir() {
        WindowsRegistry reg = WindowsRegistry.getRegistry();
        String sdkDir = WinEnvironmentVariableSupplier.getSoftwareKey(reg, "Microsoft\\Microsoft SDKs\\Windows\\v8.0", "InstallationFolder");
        if (sdkDir != null) {
            return sdkDir;
        }
        sdkDir = WinEnvironmentVariableSupplier.getSoftwareKey(reg, "Microsoft\\Microsoft SDKs\\Windows\\v7.1", "InstallationFolder");
        if (sdkDir != null) {
            return sdkDir;
        }
        return WinEnvironmentVariableSupplier.getSoftwareKey(reg, "Microsoft SDKs\\Windows\\v7.0", "InstallationFolder");
    }

    private static String getVCDir() {
        WindowsRegistry reg = WindowsRegistry.getRegistry();
        String vcDir = WinEnvironmentVariableSupplier.getSoftwareKey(reg, "Microsoft\\VisualStudio\\SxS\\VC7", "11.0");
        if (vcDir != null) {
            return vcDir;
        }
        vcDir = WinEnvironmentVariableSupplier.getSoftwareKey(reg, "Microsoft\\VisualStudio\\SxS\\VC7", "10.0");
        if (vcDir != null) {
            return vcDir;
        }
        return WinEnvironmentVariableSupplier.getSoftwareKey(reg, "Microsoft\\VisualStudio\\SxS\\VC7", "9.0");
    }

    public static IPath[] getIncludePath() {
        ArrayList<Path> includePaths = new ArrayList<Path>();
        if (sdkDir != null) {
            includePaths.add(new Path(sdkDir.concat("Include")));
            includePaths.add(new Path(sdkDir.concat("Include\\gl")));
        }
        if (vcDir != null) {
            includePaths.add(new Path(vcDir.concat("Include")));
        }
        return includePaths.toArray(new IPath[0]);
    }

    private static void addvar(IBuildEnvironmentVariable var) {
        envvars.put(var.getName(), var);
    }

    private static synchronized void initvars() {
        IPath[] includePaths;
        if (envvars != null) {
            return;
        }
        envvars = new HashMap<String, IBuildEnvironmentVariable>();
        sdkDir = WinEnvironmentVariableSupplier.getSDKDir();
        vcDir = WinEnvironmentVariableSupplier.getVCDir();
        if (sdkDir == null && vcDir == null) {
            return;
        }
        StringBuilder buff = new StringBuilder();
        IPath[] iPathArray = includePaths = WinEnvironmentVariableSupplier.getIncludePath();
        int n = includePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            buff.append(path.toOSString()).append(';');
            ++n2;
        }
        WinEnvironmentVariableSupplier.addvar(new WindowsBuildEnvironmentVariable("INCLUDE", buff.toString(), 3));
        buff = new StringBuilder();
        if (vcDir != null) {
            buff.append(vcDir).append("Lib;");
        }
        if (sdkDir != null) {
            buff.append(sdkDir).append("Lib;");
            buff.append(sdkDir).append("Lib\\win8\\um\\x86;");
        }
        WinEnvironmentVariableSupplier.addvar(new WindowsBuildEnvironmentVariable("LIB", buff.toString(), 3));
        buff = new StringBuilder();
        if (vcDir != null) {
            buff.append(vcDir).append("..\\Common7\\IDE;");
            buff.append(vcDir).append("..\\Common7\\Tools;");
            buff.append(vcDir).append("Bin;");
            buff.append(vcDir).append("vcpackages;");
        }
        if (sdkDir != null) {
            buff.append(sdkDir).append("Bin;");
        }
        WinEnvironmentVariableSupplier.addvar(new WindowsBuildEnvironmentVariable("PATH", buff.toString(), 3));
    }

    private static class WindowsBuildEnvironmentVariable
    implements IBuildEnvironmentVariable {
        private final String name;
        private final String value;
        private final int operation;

        public WindowsBuildEnvironmentVariable(String name, String value, int operation) {
            this.name = name;
            this.value = value;
            this.operation = operation;
        }

        public String getDelimiter() {
            return ";";
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getOperation() {
            return this.operation;
        }
    }
}

