/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.logging.Level;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLCompleteImageHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ReportDocumentEditor
extends EditorPart {
    private IReportEngine engine;
    private EngineConfig engineConfig;
    private Color fBackgroundColor;
    private Color fForegroundColor;
    private Color fSeparatorColor;
    private String fileName = "";
    private Composite fComposite;
    private Button detailsButton;
    private Composite detailsArea;
    private Control details = null;
    boolean showingDetails = false;
    private Exception e;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        if (this.engine == null) {
            this.init();
        }
        Display display = parent.getDisplay();
        this.fBackgroundColor = display.getSystemColor(25);
        this.fForegroundColor = display.getSystemColor(24);
        this.fSeparatorColor = ColorManager.getColor((int)152, (int)170, (int)203);
        this.fComposite = this.createComposite(parent);
        this.fComposite.setLayout((Layout)new GridLayout());
        this.createTitleLabel(this.fComposite, Messages.getString((String)"ReportDocumentEditor.1"));
        this.createLabel(this.fComposite, null);
        this.createLabel(this.fComposite, null);
        this.createHeadingLabel(this.fComposite, Messages.getString((String)"ReportDocumentEditor.2"));
        Composite separator = this.createCompositeSeparator(this.fComposite);
        GridData data = new GridData(768);
        data.heightHint = 2;
        separator.setLayoutData((Object)data);
        this.createInfomation(this.fComposite);
    }

    private void createInfomation(Composite parent) {
        Font font = parent.getFont();
        Composite continer = this.createComposite(parent, font, 2, 2, 1808, 0, 0);
        continer.setBackground(this.fBackgroundColor);
        IReportDocument document = null;
        try {
            try {
                document = this.engine.openReportDocument(this.getFileName());
                this.createScriptgLabel(continer, Messages.getString((String)"ReportDocumentEditor.3"));
                this.createScriptgLabel(continer, document.getName());
                this.createScriptgLabel(continer, Messages.getString((String)"ReportDocumentEditor.4"));
                this.createScriptgLabel(continer, document.getVersion());
                this.createScriptgLabel(continer, Messages.getString((String)"ReportDocumentEditor.5"));
                this.createScriptgLabel(continer, "" + document.getPageCount());
            }
            catch (EngineException e) {
                this.e = e;
                this.createErrorControl(continer);
                if (document != null) {
                    document.close();
                }
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private void createErrorControl(Composite parent) {
        int margins;
        Color bgColor = parent.getDisplay().getSystemColor(25);
        Color fgColor = parent.getDisplay().getSystemColor(24);
        parent.setBackground(bgColor);
        parent.setForeground(fgColor);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        int spacing = 8;
        layout.marginBottom = margins = 8;
        layout.marginTop = margins;
        layout.marginLeft = margins;
        layout.marginRight = margins;
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        parent.setLayout((Layout)layout);
        Label imageLabel = new Label(parent, 0);
        imageLabel.setBackground(bgColor);
        Image image = this.getImage();
        if (image != null) {
            image.setBackground(bgColor);
            imageLabel.setImage(image);
            imageLabel.setLayoutData((Object)new GridData(66));
        }
        Text text = new Text(parent, 74);
        text.setBackground(bgColor);
        text.setForeground(fgColor);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setText(Messages.getString((String)"ReportDocumentEditor.errorMessage"));
        this.detailsButton = new Button(parent, 8);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportDocumentEditor.this.showDetails(!ReportDocumentEditor.this.showingDetails);
            }
        });
        this.detailsButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.detailsButton.setVisible(this.e != null);
        this.updateDetailsText();
        this.detailsArea = new Composite(parent, 0);
        this.detailsArea.setBackground(bgColor);
        this.detailsArea.setForeground(fgColor);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 1;
        this.detailsArea.setLayoutData((Object)data);
        this.detailsArea.setLayout((Layout)new FillLayout());
        parent.layout(true);
    }

    private Composite createCompositeSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.fSeparatorColor);
        return composite;
    }

    private Label createTitleLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getHeaderFont());
        return label;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 64);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        GridData gd = new GridData(4, 4, true, false);
        label.setLayoutData((Object)gd);
        return label;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.fBackgroundColor);
        return composite;
    }

    private Label createHeadingLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getBannerFont());
        return label;
    }

    private Label createScriptgLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    protected void display() {
    }

    public void setFocus() {
        if (this.fComposite != null && !this.fComposite.isDisposed()) {
            this.fComposite.setFocus();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private void init() {
        this.engineConfig = new LauncherEngineConfig();
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        this.configEngine();
        this.engine = factory.createReportEngine(this.engineConfig);
        this.engine.changeLogLevel(Level.WARNING);
    }

    private void configEngine() {
        HTMLRenderOption emitterConfig = new HTMLRenderOption();
        emitterConfig.setActionHandler((IHTMLActionHandler)new HTMLActionHandler(){

            public String getURL(IAction actionDefn, Object context) {
                if (actionDefn.getType() == 3) {
                    return "birt://" + URLEncoder.encode(super.getURL(actionDefn, context));
                }
                return super.getURL(actionDefn, context);
            }
        });
        this.engineConfig.getEmitterConfigs().put("html", emitterConfig);
    }

    private Image getImage() {
        Display d = Display.getCurrent();
        return d.getSystemImage(1);
    }

    private void showDetails(boolean shouldShow) {
        if (shouldShow == this.showingDetails) {
            return;
        }
        this.showingDetails = shouldShow;
        this.updateDetailsText();
    }

    private void updateDetailsText() {
        if (this.details != null) {
            this.details.dispose();
            this.details = null;
        }
        if (this.showingDetails) {
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            Text detailsText = new Text(this.detailsArea, 33557258);
            detailsText.setText(this.getStackTrace(this.e));
            detailsText.setBackground(detailsText.getDisplay().getSystemColor(25));
            this.details = detailsText;
            this.detailsArea.layout(true);
        } else {
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        }
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        throwable.printStackTrace(pwriter);
        pwriter.flush();
        pwriter.close();
        return swriter.toString();
    }

    static class LauncherEngineConfig
    extends EngineConfig {
        public LauncherEngineConfig() {
            HTMLRenderOption emitterConfig = (HTMLRenderOption)this.getEmitterConfigs().get("html");
            emitterConfig.setImageHandler((IHTMLImageHandler)new HTMLCompleteImageHandler());
        }
    }
}

