/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;

public class CubeExpressionProvider
extends ExpressionProvider {
    private DataSetHandle dataSetHandle = null;

    public CubeExpressionProvider(DesignElementHandle handle) {
        super(handle);
        if (handle instanceof TabularCubeHandle) {
            this.dataSetHandle = ((TabularCubeHandle)handle).getDataSet();
        }
        if (handle instanceof DimensionHandle) {
            if (((DimensionHandle)handle).getDefaultHierarchy() instanceof TabularHierarchyHandle) {
                this.dataSetHandle = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)((DimensionHandle)handle).getDefaultHierarchy());
            }
        } else if (handle instanceof TabularHierarchyHandle) {
            this.dataSetHandle = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)handle);
        } else if (handle instanceof TabularMeasureHandle) {
            DesignElementHandle parent = ((MeasureHandle)handle).getContainer().getContainer();
            if (parent instanceof TabularCubeHandle) {
                this.dataSetHandle = ((TabularCubeHandle)parent).getDataSet();
            }
        } else if (handle instanceof MeasureGroupHandle) {
            DesignElementHandle parent = ((MeasureGroupHandle)handle).getContainer().getContainer();
            if (parent instanceof TabularCubeHandle) {
                this.dataSetHandle = ((TabularCubeHandle)parent).getDataSet();
            }
        } else if (handle instanceof TabularLevelHandle) {
            this.dataSetHandle = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)handle.getContainer());
        }
        this.addFilterToProvider();
    }

    protected void addFilterToProvider() {
        this.addFilter(new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                if ("Category".equals(parentElement) && ExpressionProvider.CURRENT_CUBE.equals(element)) {
                    return false;
                }
                return !"Category".equals(parentElement) || !"Measure".equals(element);
            }
        });
    }

    protected List getCategoryList() {
        List categoryList = super.getCategoryList();
        if (this.dataSetHandle != null) {
            categoryList.add(DATASETS);
        }
        return categoryList;
    }

    protected List getChildrenList(Object parent) {
        if (DATASETS.equals(parent)) {
            ArrayList<DataSetHandle> dataSeList = new ArrayList<DataSetHandle>();
            dataSeList.add(this.dataSetHandle);
            return dataSeList;
        }
        if (parent instanceof DataSetHandle) {
            try {
                List columnList = DataUtil.getColumnList((DataSetHandle)((DataSetHandle)parent));
                List outputList = this.getOutputList((DataSetHandle)parent);
                columnList.addAll(outputList);
                return columnList;
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
                return Collections.EMPTY_LIST;
            }
        }
        return super.getChildrenList(parent);
    }

    protected List getOutputList(DataSetHandle handle) {
        ArrayList outputList = new ArrayList();
        PropertyHandle parameters = handle.getPropertyHandle("parameters");
        Iterator iter = parameters.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                Object dataSetParameter = iter.next();
                if (!((DataSetParameterHandle)dataSetParameter).isOutput()) continue;
                outputList.add(dataSetParameter);
            }
        }
        return outputList;
    }

    public String getDisplayText(Object element) {
        if (element instanceof DataSetHandle) {
            return ((DataSetHandle)element).getName();
        }
        if (element instanceof ResultSetColumnHandle) {
            return ((ResultSetColumnHandle)element).getColumnName();
        }
        if (element instanceof DataSetParameterHandle) {
            return ((DataSetParameterHandle)element).getName();
        }
        return super.getDisplayText(element);
    }

    public String getInsertText(Object element) {
        if (element instanceof ResultSetColumnHandle || element instanceof DataSetParameterHandle) {
            return DEUtil.getExpression((Object)element);
        }
        return super.getInsertText(element);
    }
}

