/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.AbstractChartBaseQueryGenerator;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartReportItemHelper;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.emf.common.util.EList;

public class ChartBaseQueryHelper
extends AbstractChartBaseQueryGenerator {
    public ChartBaseQueryHelper(ReportItemHandle handle, Chart cm, IModelAdapter modelAdapter) {
        this(handle, cm, modelAdapter, true);
    }

    public ChartBaseQueryHelper(ReportItemHandle handle, Chart cm, IModelAdapter modelAdapter, boolean bCreateBindingForExpression) {
        super(handle, cm, bCreateBindingForExpression, modelAdapter);
    }

    @Override
    public IDataQueryDefinition createBaseQuery(IDataQueryDefinition parent) throws ChartException {
        BaseQueryDefinition query = this.createQueryDefinition(parent);
        if (query == null) {
            return null;
        }
        this.generateExtraBindings(query);
        return query;
    }

    protected BaseQueryDefinition createQueryDefinition(IDataQueryDefinition parent) throws ChartException {
        DataSetHandle dsHandle;
        QueryDefinition query = null;
        BaseQueryDefinition parentQuery = null;
        if (parent instanceof BaseQueryDefinition) {
            parentQuery = (BaseQueryDefinition)parent;
        }
        if ((dsHandle = this.fReportItemHandle.getDataSet()) == null) {
            String dsName = (String)this.fReportItemHandle.getProperty("dataSet");
            if (dsName != null && dsName.length() > 0) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)new EngineException("Error.UndefinedDatasetError", (Object)dsName));
            }
            if (parent instanceof ICubeQueryDefinition) {
                return null;
            }
            if (ChartReportItemUtil.canScaleShared(this.fReportItemHandle, this.fChartModel)) {
                this.addMinMaxBinding(ChartItemUtil.getBindingHolder((DesignElementHandle)this.fReportItemHandle), parentQuery);
            }
            query = this.createSubQuery(this.fReportItemHandle, parentQuery);
        } else {
            query = new QueryDefinition((IDataQueryDefinition)parentQuery);
            query.setIsSummaryQuery(this.needSummaryQuery());
            query.setDataSetName(dsHandle.getQualifiedName());
            query.getInputParamBindings().addAll(this.createParamBindings(this.fReportItemHandle.paramBindingsIterator()));
            Iterator<?> iter = this.getAllUsedBindings(this.fReportItemHandle);
            while (iter.hasNext()) {
                ComputedColumnHandle binding = (ComputedColumnHandle)iter.next();
                this.addColumnBinding((IBaseQueryDefinition)query, binding);
            }
            this.addSortAndFilter(this.fReportItemHandle, (BaseQueryDefinition)query);
        }
        return query;
    }

    protected Iterator<?> getAllUsedBindings(ReportItemHandle handle) {
        return ChartReportItemHelper.instance().getAllUsedBindings(this.fChartModel, handle);
    }

    protected void addColumnBinding(IBaseQueryDefinition transfer, ComputedColumnHandle columnBinding) throws ChartException {
        try {
            transfer.addBinding(this.modelAdapter.adaptBinding(columnBinding));
        }
        catch (AdapterException ex) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)ex);
        }
        catch (DataException ex) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)ex);
        }
    }

    private void addMinMaxBinding(ReportItemHandle handle, BaseQueryDefinition query) throws ChartException {
        try {
            String queryExp = this.getExpressionOfValueSeries();
            ComputedColumn ccMin = StructureFactory.newComputedColumn((DesignElementHandle)handle, (String)"chart__min");
            ccMin.setAggregateFunction("min");
            ccMin.setExpression(queryExp);
            this.addColumnBinding((IBaseQueryDefinition)query, handle.addColumnBinding(ccMin, false));
            ComputedColumn ccMax = StructureFactory.newComputedColumn((DesignElementHandle)handle, (String)"chart__max");
            ccMax.setAggregateFunction("max");
            ccMax.setExpression(queryExp);
            this.addColumnBinding((IBaseQueryDefinition)query, handle.addColumnBinding(ccMax, false));
        }
        catch (SemanticException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
        }
    }

    protected BaseQueryDefinition createSubQuery(ReportItemHandle handle, BaseQueryDefinition parentQuery) throws ChartException {
        QueryDefinition query = null;
        if (parentQuery == null) {
            query = new QueryDefinition(null);
        } else {
            query = new SubqueryDefinition("chart_subquery" + handle.getElement().getID(), (IBaseQueryDefinition)parentQuery);
            parentQuery.getSubqueries().add(query);
        }
        Iterator<?> iter = this.getAllUsedBindings(handle);
        while (iter.hasNext()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)iter.next();
            this.addColumnBinding((IBaseQueryDefinition)query, binding);
        }
        this.addSortAndFilter(handle, (BaseQueryDefinition)query);
        return query;
    }

    protected void addSortAndFilter(ReportItemHandle handle, BaseQueryDefinition query) {
        if (handle instanceof ExtendedItemHandle) {
            query.getFilters().addAll(ChartBaseQueryHelper.createFilters(this.modelAdapter, ((ExtendedItemHandle)handle).filtersIterator()));
        } else if (handle instanceof TableHandle) {
            query.getFilters().addAll(ChartBaseQueryHelper.createFilters(this.modelAdapter, ((TableHandle)handle).filtersIterator()));
        }
    }

    protected static List<IFilterDefinition> createFilters(IModelAdapter modelAdapter, Iterator<FilterConditionHandle> iter) {
        ArrayList<IFilterDefinition> filters = new ArrayList<IFilterDefinition>();
        if (iter != null) {
            while (iter.hasNext()) {
                FilterConditionHandle filterHandle = iter.next();
                FilterDefinition filter = modelAdapter.adaptFilter(filterHandle);
                filters.add((IFilterDefinition)filter);
            }
        }
        return filters;
    }

    protected List<IInputParameterBinding> createParamBindings(Iterator<ParamBindingHandle> iter) throws ChartException {
        ArrayList<IInputParameterBinding> list = new ArrayList<IInputParameterBinding>();
        if (iter != null) {
            while (iter.hasNext()) {
                ParamBindingHandle modelParamBinding = iter.next();
                List<ScriptExpression> exprs = ChartReportItemUtil.newExpression(this.modelAdapter, modelParamBinding);
                for (ScriptExpression expr : exprs) {
                    list.add((IInputParameterBinding)new InputParameterBinding(modelParamBinding.getParamName(), (IBaseExpression)expr));
                }
            }
        }
        return list;
    }

    private String getExpressionOfValueSeries() {
        SeriesDefinition ySd;
        if (this.fChartModel instanceof ChartWithAxes) {
            Axis yAxis = (Axis)((Axis)((ChartWithAxes)this.fChartModel).getAxes().get(0)).getAssociatedAxes().get(0);
            ySd = (SeriesDefinition)yAxis.getSeriesDefinitions().get(0);
        } else {
            ySd = (SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.fChartModel).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(0);
        }
        Query query = (Query)ySd.getDesignTimeSeries().getDataDefinition().get(0);
        return query.getDefinition();
    }

    public IDataQueryDefinition createBaseQuery(List columns) {
        throw new UnsupportedOperationException("Don't be implemented in the class.");
    }

    public static List<Query> getAllQueryExpressionDefinitions(Chart chart) {
        ArrayList<Query> queryList = new ArrayList<Query>();
        if (chart instanceof ChartWithAxes) {
            Axis xAxis = (Axis)((ChartWithAxes)chart).getAxes().get(0);
            queryList.addAll(ChartBaseQueryHelper.getQueries((EList<SeriesDefinition>)xAxis.getSeriesDefinitions()));
            EList axisList = xAxis.getAssociatedAxes();
            int i = 0;
            while (i < axisList.size()) {
                EList sds = ((Axis)axisList.get(i)).getSeriesDefinitions();
                Query q = ((SeriesDefinition)sds.get(0)).getQuery();
                if (q != null) {
                    queryList.add(q);
                }
                queryList.addAll(ChartBaseQueryHelper.getQueries((EList<SeriesDefinition>)sds));
                ++i;
            }
        } else if (chart instanceof ChartWithoutAxes) {
            SeriesDefinition sdBase = (SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0);
            queryList.addAll((Collection<Query>)sdBase.getDesignTimeSeries().getDataDefinition());
            Query q = ((SeriesDefinition)sdBase.getSeriesDefinitions().get(0)).getQuery();
            if (q != null) {
                queryList.add(q);
            }
            queryList.addAll(ChartBaseQueryHelper.getQueries((EList<SeriesDefinition>)sdBase.getSeriesDefinitions()));
        }
        return queryList;
    }

    private static List<Query> getQueries(EList<SeriesDefinition> seriesDefinitions) {
        ArrayList<Query> querys = new ArrayList<Query>();
        Iterator iter = seriesDefinitions.iterator();
        while (iter.hasNext()) {
            querys.addAll((Collection<Query>)((SeriesDefinition)iter.next()).getDesignTimeSeries().getDataDefinition());
        }
        return querys;
    }

    public static IGroupDefinition handleGroup(GroupHandle handle, IBaseQueryDefinition query, IModelAdapter modelAdapter) {
        GroupDefinition groupDefn = new GroupDefinition(handle.getName());
        groupDefn.setKeyExpression((IScriptExpression)modelAdapter.adaptExpression(ChartReportItemUtil.getExpression(handle)));
        String interval = handle.getInterval();
        if (interval != null) {
            groupDefn.setInterval(ChartBaseQueryHelper.parseInterval(interval));
        }
        groupDefn.setIntervalRange(handle.getIntervalRange());
        groupDefn.setIntervalStart((Object)handle.getIntervalBase());
        String direction = handle.getSortDirection();
        if (direction != null) {
            groupDefn.setSortDirection(ChartBaseQueryHelper.parseSortDirection(direction));
        }
        groupDefn.getSorts().addAll(ChartBaseQueryHelper.createSorts(handle, modelAdapter));
        groupDefn.getFilters().addAll(ChartBaseQueryHelper.createFilters(modelAdapter, handle));
        query.getGroups().add(groupDefn);
        return groupDefn;
    }

    private static int parseInterval(String interval) {
        if ("year".equals(interval)) {
            return 1;
        }
        if ("month".equals(interval)) {
            return 2;
        }
        if ("week".equals(interval)) {
            return 4;
        }
        if ("quarter".equals(interval)) {
            return 3;
        }
        if ("day".equals(interval)) {
            return 5;
        }
        if ("hour".equals(interval)) {
            return 6;
        }
        if ("minute".equals(interval)) {
            return 7;
        }
        if ("prefix".equals(interval)) {
            return 100;
        }
        if ("second".equals(interval)) {
            return 8;
        }
        if ("interval".equals(interval)) {
            return 99;
        }
        return 0;
    }

    private static int parseSortDirection(String direction) {
        if ("asc".equals(direction)) {
            return 0;
        }
        if ("desc".equals(direction)) {
            return 1;
        }
        assert (false);
        return 0;
    }

    private static List<IFilterDefinition> createFilters(IModelAdapter modelAdapter, GroupHandle group) {
        return ChartBaseQueryHelper.createFilters(modelAdapter, group.filtersIterator());
    }

    public static List<ISortDefinition> createSorts(Iterator<SortKeyHandle> iter, IModelAdapter modelAdapter) {
        ArrayList<ISortDefinition> sorts = new ArrayList<ISortDefinition>();
        if (iter != null) {
            while (iter.hasNext()) {
                sorts.add((ISortDefinition)modelAdapter.adaptSort(iter.next()));
            }
        }
        return sorts;
    }

    private static List<ISortDefinition> createSorts(GroupHandle group, IModelAdapter modelAdapter) {
        return ChartBaseQueryHelper.createSorts(group.sortsIterator(), modelAdapter);
    }

    protected boolean needSummaryQuery() {
        if (this.fReportItemHandle instanceof TableHandle) {
            return ((TableHandle)this.fReportItemHandle).isSummaryTable();
        }
        return false;
    }
}

