/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.AbstractResourceBlockingJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;

public class ResourceBlockingOperationJob
extends AbstractResourceBlockingJob {
    private final Collection<? extends IOperation> m_operations;

    public ResourceBlockingOperationJob(IOperation operation) {
        this(operation, null);
    }

    public ResourceBlockingOperationJob(IOperation operation, IResource ... resources) {
        this(operation == null ? Collections.emptyList() : Collections.singletonList(operation), resources);
    }

    public ResourceBlockingOperationJob(Collection<? extends IOperation> operations) {
        this(operations, null);
    }

    public ResourceBlockingOperationJob(Collection<? extends IOperation> operations, IResource ... resources) {
        this(ResourceBlockingOperationJob.cleanList(operations), resources);
    }

    protected ResourceBlockingOperationJob(List<? extends IOperation> cleanOperations, IResource[] resources) {
        super(ResourceBlockingOperationJob.getJobName(cleanOperations), resources);
        this.m_operations = cleanOperations;
    }

    protected static <T> List<T> cleanList(Collection<T> c) {
        if (c == null || c.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(c.size());
        for (T element : c) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    protected static String getJobName(Collection<? extends IOperation> operations) {
        if (operations.isEmpty()) {
            return "";
        }
        StringBuilder nameBuilder = new StringBuilder();
        Iterator<? extends IOperation> iterator = operations.iterator();
        ResourceBlockingOperationJob.appendName(iterator.next(), nameBuilder);
        while (iterator.hasNext()) {
            nameBuilder.append(", ");
            ResourceBlockingOperationJob.appendName(iterator.next(), nameBuilder);
        }
        return nameBuilder.toString();
    }

    protected static void appendName(IOperation op, StringBuilder nameBuilder) {
        String itOpName = op.getOperationName();
        if (StringUtils.isBlank((CharSequence)itOpName)) {
            SdkLog.warning((String)"operation '{}' does not have a name.", (Object[])new Object[]{op.getClass().getName()});
            itOpName = "Missing operation name.";
        }
        nameBuilder.append(itOpName);
    }

    @Override
    protected void validate() {
        for (IOperation iOperation : this.m_operations) {
            iOperation.validate();
        }
    }

    @Override
    protected final void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)(this.m_operations.size() * 100));
        if (progress.isCanceled()) {
            return;
        }
        for (IOperation iOperation : this.m_operations) {
            iOperation.run((IProgressMonitor)progress.newChild(100), workingCopyManager);
        }
    }
}

