/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutStatus;

public class WorkingCopyManager
implements IWorkingCopyManager {
    private final Set<ICompilationUnit> m_workingCopies = new LinkedHashSet<ICompilationUnit>();

    @Override
    public synchronized boolean register(ICompilationUnit icu, IProgressMonitor monitor) throws JavaModelException {
        if (!this.m_workingCopies.contains(icu)) {
            icu.becomeWorkingCopy(monitor);
            this.m_workingCopies.add(icu);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void unregisterAll(IProgressMonitor monitor, boolean save) {
        boolean tryToSave;
        boolean bl = tryToSave = save && !monitor.isCanceled();
        if (tryToSave) {
            IStatus result;
            ArrayList<IResource> resourcesToSave = new ArrayList<IResource>(this.m_workingCopies.size());
            for (ICompilationUnit icu : this.m_workingCopies) {
                IResource resource = icu.getResource();
                resourcesToSave.add(resource);
            }
            if (!resourcesToSave.isEmpty() && !(result = S2eUtils.makeCommittable(resourcesToSave)).isOK()) {
                tryToSave = false;
                SdkLog.warning((String)"Unable to make all resources committable. Save will be skipped.", (Object[])new Object[]{new CoreException(result)});
            }
        }
        for (ICompilationUnit icu : this.m_workingCopies) {
            WorkingCopyManager.releaseCompilationUnit(icu, monitor, tryToSave);
        }
        this.m_workingCopies.clear();
    }

    private static void releaseCompilationUnit(ICompilationUnit icu, IProgressMonitor monitor, boolean tryToSave) {
        block12: {
            try {
                try {
                    if (tryToSave) {
                        icu.commitWorkingCopy(true, monitor);
                        WorkingCopyManager.indexCompilationUnitSync(icu);
                    }
                }
                catch (Exception e) {
                    SdkLog.warning((String)"Unable to commit working copy '{}'.", (Object[])new Object[]{icu.getElementName(), e});
                    try {
                        icu.discardWorkingCopy();
                    }
                    catch (JavaModelException e2) {
                        SdkLog.warning((String)"Unable to discard working copy '{}'.", (Object[])new Object[]{icu.getElementName(), e2});
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    icu.discardWorkingCopy();
                }
                catch (JavaModelException e) {
                    SdkLog.warning((String)"Unable to discard working copy '{}'.", (Object[])new Object[]{icu.getElementName(), e});
                }
                throw throwable;
            }
            try {
                icu.discardWorkingCopy();
            }
            catch (JavaModelException e) {
                SdkLog.warning((String)"Unable to discard working copy '{}'.", (Object[])new Object[]{icu.getElementName(), e});
            }
        }
    }

    private static void indexCompilationUnitSync(ICompilationUnit icu) {
        IJavaProject jp = icu.getJavaProject();
        IndexManager im = JavaModelManager.getIndexManager();
        IPath containerPath = jp.getProject().getFullPath();
        SourceElementParser parser = im.getSourceElementParser(jp, null);
        im.addSource((IFile)icu.getResource(), containerPath, parser);
        AbstractJob.waitForJobFamily(containerPath.toString());
    }

    @Override
    public synchronized void reconcile(ICompilationUnit icu, IProgressMonitor monitor) throws CoreException {
        if (!this.m_workingCopies.contains(icu)) {
            throw new CoreException((IStatus)new ScoutStatus("compilation unit " + icu.getElementName() + " has not been registered"));
        }
        icu.reconcile(0, true, icu.getOwner(), monitor);
    }
}

