/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.net.Inet4Address;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.ui.DebugServerConnectionTestRegistry;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.core.util.NetworkMonitor;
import org.eclipse.php.internal.core.util.NetworkUtil;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsWorkingCopy;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.zend.communication.DebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.zend.debugger.ConfigureHostsDialog;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerHostProposalComputer;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.ui.wizards.IDebuggerSettingsSection;
import org.eclipse.php.internal.debug.ui.wizards.Messages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ZendDebuggerServerSettingsSection
implements IDebuggerSettingsSection {
    private IDebuggerSettingsWorkingCopy settingsWorkingCopy;
    private CompositeFragment compositeFragment;
    private Composite settingsComposite;
    private Text clientIpText;
    private NetworkMonitor networkMonitor;
    private boolean skipNetworkMonitor = false;

    public ZendDebuggerServerSettingsSection(CompositeFragment compositeFragment, Composite debuggerSettingsComposite, IDebuggerSettingsWorkingCopy settingsWorkingCopy) {
        this.settingsWorkingCopy = settingsWorkingCopy;
        this.compositeFragment = compositeFragment;
        this.settingsComposite = debuggerSettingsComposite;
        this.networkMonitor = new NetworkMonitor();
        this.createContents();
    }

    @Override
    public boolean performOK() {
        return true;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void validate() {
        this.compositeFragment.setMessage(this.compositeFragment.getDescription(), 0);
        String clientIp = this.settingsWorkingCopy.getAttribute("clientIp");
        if (clientIp == null || clientIp.isEmpty()) {
            this.compositeFragment.setMessage(Messages.ZendDebuggerServerSettingsSection_Client_IP_is_missing, 3);
            return;
        }
        String clientPort = this.settingsWorkingCopy.getAttribute("clientPort");
        if (clientPort == null || clientPort.isEmpty()) {
            this.compositeFragment.setMessage(Messages.ZendDebuggerServerSettingsSection_Client_port_is_missing, 3);
            return;
        }
        String responseTime = this.settingsWorkingCopy.getAttribute("responseTimeout");
        Integer responseTimeout = null;
        try {
            responseTimeout = Integer.valueOf(responseTime);
            int i = responseTimeout;
            if (i < 5000) {
                this.compositeFragment.setMessage(NLS.bind((String)PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_invalid_response_time, (Object)5000), 3);
                return;
            }
        }
        catch (Exception exc) {
            this.compositeFragment.setMessage(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_invalid_response_time_exc, 3);
            return;
        }
        String[] clientHosts = PHPDebugUtil.getZendHostsArray((String)this.clientIpText.getText());
        if (!this.skipNetworkMonitor) {
            this.networkMonitor.validate(clientHosts, new NetworkMonitor.IHostsValidationListener[]{new NetworkMonitor.IHostsValidationListener(){

                public void validated(List<String> invalidAddresses) {
                    if (!invalidAddresses.isEmpty()) {
                        StringBuilder addresses = new StringBuilder();
                        for (String address : invalidAddresses) {
                            addresses.append(String.valueOf(addresses.length() != 0 ? ", " : "") + '\'' + address + '\'');
                        }
                        String message = invalidAddresses.size() == 1 ? MessageFormat.format(Messages.ZendDebuggerServerSettingsSection_Client_host_IP_might_be_invalid, addresses.toString()) : MessageFormat.format(Messages.ZendDebuggerServerSettingsSection_Client_hosts_IPs_might_be_invalid, addresses.toString());
                        final String warningMessage = message;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!ZendDebuggerServerSettingsSection.this.compositeFragment.isDisposed() && ZendDebuggerServerSettingsSection.this.compositeFragment.isVisible() && ZendDebuggerServerSettingsSection.this.compositeFragment.isComplete()) {
                                    ZendDebuggerServerSettingsSection.this.compositeFragment.setMessage(warningMessage, 2);
                                }
                            }
                        });
                    } else {
                        ZendDebuggerServerSettingsSection.this.skipNetworkMonitor = true;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!ZendDebuggerServerSettingsSection.this.compositeFragment.isDisposed() && ZendDebuggerServerSettingsSection.this.compositeFragment.isVisible()) {
                                    ZendDebuggerServerSettingsSection.this.validate();
                                }
                            }
                        });
                    }
                }
            }});
        } else {
            this.skipNetworkMonitor = false;
        }
        if (clientHosts.length > 1) {
            this.compositeFragment.setMessage(Messages.ZendDebuggerServerSettingsSection_Client_host_IPS_might_be_redundant, 2);
            return;
        }
        Integer portNumber = null;
        try {
            portNumber = Integer.valueOf(clientPort);
            int i = portNumber;
            if (i < 1 || i > 65535) {
                this.compositeFragment.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPortRange, 3);
                return;
            }
        }
        catch (NumberFormatException ex) {
            this.compositeFragment.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        catch (Exception e) {
            this.compositeFragment.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        if (!PHPLaunchUtilities.isPortAvailable((int)portNumber) && !PHPLaunchUtilities.isDebugDaemonActive((int)portNumber, (String)"org.eclipse.php.debug.core.zendDebugger")) {
            this.compositeFragment.setMessage(MessageFormat.format(Messages.DebuggerCommonSettingsSection_Port_is_already_in_use, clientPort), 2);
            return;
        }
    }

    @Override
    public boolean canTest() {
        return true;
    }

    @Override
    public void performTest() {
        IDebugServerConnectionTest[] tests = DebugServerConnectionTestRegistry.getTests("org.eclipse.php.debug.core.zendDebugger");
        Server server = (Server)this.compositeFragment.getData();
        int port = ZendDebuggerSettingsUtil.getDebugPort((String)this.settingsWorkingCopy.getOwnerId());
        Set allDebugPorts = PHPDebugUtil.getDebugPorts((String)"org.eclipse.php.debug.core.zendDebugger");
        AbstractDebuggerCommunicationDaemon tmpDaemon = null;
        if (!allDebugPorts.contains(port)) {
            tmpDaemon = DebuggerCommunicationDaemon.createDaemon((int)port);
        }
        IDebugServerConnectionTest[] iDebugServerConnectionTestArray = tests;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugServerConnectionTest test = iDebugServerConnectionTestArray[n2];
            test.testConnection(server, PlatformUI.getWorkbench().getDisplay().getActiveShell());
            ++n2;
        }
        if (tmpDaemon != null) {
            tmpDaemon.stopListen();
        }
    }

    protected void createContents() {
        Composite settingsSection = new Composite(this.settingsComposite, 0);
        GridLayout ssLayout = new GridLayout();
        ssLayout.marginHeight = 0;
        ssLayout.marginWidth = 0;
        settingsSection.setLayout((Layout)ssLayout);
        GridData sGridData = new GridData(4, 4, true, true);
        sGridData.horizontalSpan = 2;
        settingsSection.setLayoutData((Object)sGridData);
        this.createSettingsGroup(settingsSection);
    }

    private void createSettingsGroup(Composite settingsSection) {
        Group connectionGroup = new Group(settingsSection, 0);
        connectionGroup.setFont(this.compositeFragment.getFont());
        GridLayout cgLayout = new GridLayout(3, false);
        connectionGroup.setLayout((Layout)cgLayout);
        GridData cgGridData = new GridData(768);
        connectionGroup.setLayoutData((Object)cgGridData);
        connectionGroup.setText(Messages.ZendDebuggerServerSettingsSection_Connection_settings);
        this.createConnectionSection(connectionGroup);
    }

    private void createConnectionSection(Group connectionGroup) {
        Label clientIpLabel = new Label((Composite)connectionGroup, 0);
        clientIpLabel.setText(Messages.ZendDebuggerServerSettingsSection_Client_IPs);
        this.clientIpText = new Text((Composite)connectionGroup, 2048);
        GridData citLayoutData = new GridData(768);
        this.clientIpText.setLayoutData((Object)citLayoutData);
        this.clientIpText.setText(this.settingsWorkingCopy.getAttribute("clientIp"));
        this.clientIpText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String clientIp = ZendDebuggerServerSettingsSection.this.clientIpText.getText();
                ZendDebuggerServerSettingsSection.this.settingsWorkingCopy.setAttribute("clientIp", clientIp);
                ZendDebuggerServerSettingsSection.this.validate();
            }
        });
        String ipTextProposal = this.getIPsProposal();
        if (ipTextProposal != null) {
            this.clientIpText.setText(ipTextProposal);
        }
        Button configureIPs = SWTFactory.createPushButton((Composite)connectionGroup, (String)Messages.ZendDebuggerServerSettingsSection_Configure_button, null);
        configureIPs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String clientIPs = ZendDebuggerServerSettingsSection.this.getClientIPs(ZendDebuggerServerSettingsSection.this.clientIpText.getText());
                if (!clientIPs.isEmpty()) {
                    ZendDebuggerServerSettingsSection.this.clientIpText.setText(clientIPs);
                    ZendDebuggerServerSettingsSection.this.validate();
                }
            }
        });
        Label clientPortLabel = new Label((Composite)connectionGroup, 0);
        clientPortLabel.setText(Messages.ZendDebuggerServerSettingsSection_Client_port);
        final Text clientPortText = new Text((Composite)connectionGroup, 2048);
        GridData cptLayoutData = new GridData(768);
        cptLayoutData.horizontalSpan = 2;
        clientPortText.setLayoutData((Object)cptLayoutData);
        clientPortText.setText(this.settingsWorkingCopy.getAttribute("clientPort"));
        clientPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String port = clientPortText.getText();
                ZendDebuggerServerSettingsSection.this.settingsWorkingCopy.setAttribute("clientPort", port);
                ZendDebuggerServerSettingsSection.this.validate();
            }
        });
        Label responseTimeoutLabel = new Label((Composite)connectionGroup, 0);
        responseTimeoutLabel.setText(Messages.ZendDebuggerServerSettingsSection_Response_timeout);
        final Text responseTimeoutText = new Text((Composite)connectionGroup, 2048);
        GridData rttLayoutData = new GridData(768);
        rttLayoutData.horizontalSpan = 2;
        responseTimeoutText.setLayoutData((Object)rttLayoutData);
        responseTimeoutText.setText(this.settingsWorkingCopy.getAttribute("responseTimeout"));
        responseTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String responseTimeout = responseTimeoutText.getText();
                ZendDebuggerServerSettingsSection.this.settingsWorkingCopy.setAttribute("responseTimeout", responseTimeout);
                ZendDebuggerServerSettingsSection.this.validate();
            }
        });
    }

    private String getIPsProposal() {
        final Server server = (Server)this.compositeFragment.getData();
        if (server == null || ServersManager.findServer((String)server.getUniqueId()) != null) {
            return null;
        }
        final StringBuilder bestMatches = new StringBuilder();
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                String proposals = new ZendDebuggerHostProposalComputer().computeProposals(server);
                if (proposals != null) {
                    bestMatches.append(proposals);
                }
            }
        });
        return bestMatches.length() != 0 ? bestMatches.toString() : null;
    }

    private String getClientIPs(String userHosts) {
        final ArrayList detectedIPs = new ArrayList();
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ZendDebuggerServerSettingsSection.this.networkMonitor = new NetworkMonitor();
                detectedIPs.addAll(ZendDebuggerServerSettingsSection.this.networkMonitor.getAllAddresses());
            }
        });
        String[] userHostsArray = PHPDebugUtil.getZendHostsArray((String)userHosts);
        ArrayList<Inet4Address> userIPs = new ArrayList<Inet4Address>();
        String[] stringArray = userHostsArray;
        int n = userHostsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String userHost = stringArray[n2];
            Inet4Address address = NetworkUtil.getByName((String)userHost, (int)2000);
            if (address != null) {
                userIPs.add(address);
            }
            ++n2;
        }
        ConfigureHostsDialog configureIPs = new ConfigureHostsDialog(userIPs, detectedIPs);
        int choice = configureIPs.open();
        if (choice != 0) {
            return "";
        }
        List selectdIPs = configureIPs.getSelectedIPs();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator ipsIterator = selectdIPs.iterator();
        if (ipsIterator.hasNext()) {
            stringBuffer.append(((Inet4Address)ipsIterator.next()).getHostAddress());
        }
        while (ipsIterator.hasNext()) {
            stringBuffer.append(", " + ((Inet4Address)ipsIterator.next()).getHostAddress());
        }
        return stringBuffer.toString();
    }
}

