/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.ActivityExplorerEditorPartListener;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.CommonActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.DocumentationActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.OverviewActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager.ActivityExplorerExtensionManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IActivityExplorerEditorSessionListener;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IVisibility;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ActivityExplorerEditor
extends SharedHeaderFormEditor
implements ITabbedPropertySheetPageContributor,
IPropertyChangeListener,
IActivityExplorerEditorSessionListener {
    public static final String ID = "org.eclipse.amalgam.explorer.activity.ui.editor.activityExplorerEditor";
    private IPartListener _partListener;
    private TabbedPropertySheetPage _propertySheetPage;
    private int backToActivePage = 0;
    public static final String PROPERTIES_CONTRIBUTOR = "org.eclipse.amalgam.explorer.activity.ui.editor.properties";

    public ActivityExplorerEditor() {
        ActivityExplorerManager.INSTANCE.setEditor(this);
        ActivityExplorerManager.INSTANCE.addActivityExplorerEditorListener(this);
        this._partListener = new ActivityExplorerEditorPartListener(this);
    }

    public void setFocus() {
        super.setFocus();
        this.getContainer().setFocus();
        ActivityExplorerManager.INSTANCE.setEditor(this);
    }

    protected void addPages() {
        try {
            ActivityExplorerManager.INSTANCE.setEditor(this);
            this.createContributedPages();
        }
        catch (PartInitException exception) {
            StringBuilder loggerMessage = new StringBuilder("ActivityExplorerEditor.addPages(..) _ ");
            loggerMessage.append(exception.getMessage());
            ActivityExplorerLoggerService.getInstance().log(4, loggerMessage.toString(), exception);
        }
        catch (Exception exception) {
            StringBuilder loggerMessage = new StringBuilder("ActivityExplorerEditor.addPages(..) _ ");
            loggerMessage.append(exception.getMessage());
            ActivityExplorerLoggerService.getInstance().log(2, loggerMessage.toString(), exception);
        }
        this.getContainer().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent cevent) {
            }

            public void controlResized(ControlEvent cevent) {
                IFormPage activePageInstance = ActivityExplorerEditor.this.getActivePageInstance();
                IManagedForm managedForm = activePageInstance.getManagedForm();
                managedForm.reflow(true);
            }
        });
        this.getHeaderForm().dirtyStateChanged();
        ActivityExplorerActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.pages.remove(null);
    }

    public Vector<CommonActivityExplorerPage> getPages() {
        Vector<CommonActivityExplorerPage> result = new Vector<CommonActivityExplorerPage>(this.pages.size());
        for (Object obj : this.pages) {
            if (!(obj instanceof CommonActivityExplorerPage)) continue;
            result.add((CommonActivityExplorerPage)obj);
        }
        return result;
    }

    public void removeAllPages() {
        this.backToActivePage = this.getActivePage();
        int count = super.getPageCount();
        int i = count - 1;
        while (i >= 0) {
            if (i != this.backToActivePage) {
                this.removePage(i);
            }
            --i;
        }
        this.removePage(0);
    }

    private void createContributedPages() throws PartInitException {
        List<CommonActivityExplorerPage> contributedPages = ActivityExplorerExtensionManager.getAllPages();
        Collections.sort(contributedPages);
        this.addOverviewPage(contributedPages);
        this.addContributedPages(contributedPages);
    }

    private void addContributedPages(List<CommonActivityExplorerPage> contributedPages) {
        for (CommonActivityExplorerPage page : contributedPages) {
            if (!(page instanceof IVisibility) || page.getPosition() == 0) continue;
            try {
                if (!page.isVisible()) continue;
                this.addNewPage((IFormPage)page);
            }
            catch (Throwable e) {
                StringBuilder loggerMessage = new StringBuilder("ActivityExplorerEditor.addContributedPages(..) _ ");
                loggerMessage.append("An error was occured at the evaluation of the predicat or the adding of page ").append(page.getId());
                loggerMessage.append(". Refer to the exception stack for more details");
                ActivityExplorerLoggerService.getInstance().log(4, loggerMessage.toString(), e);
            }
        }
    }

    private void addOverviewPage(List<CommonActivityExplorerPage> contributedPages) throws PartInitException {
        OverviewActivityExplorerPage overviewPage = null;
        for (CommonActivityExplorerPage page : contributedPages) {
            try {
                if (page.getPosition() != 0) break;
                if (page instanceof OverviewActivityExplorerPage && page.isVisible()) {
                    overviewPage = (OverviewActivityExplorerPage)page;
                    break;
                }
                if (!page.isVisible()) continue;
                StringBuilder loggerMessage = new StringBuilder("ActivityExplorerEditor.addOverviewPage(..) _ ");
                loggerMessage.append("Page ").append(page.getId());
                loggerMessage.append(" is not an overview page. Only overview pages are allowed to index 0");
                ActivityExplorerLoggerService.getInstance().log(2, loggerMessage.toString(), null);
            }
            catch (Throwable e) {
                StringBuilder loggerMessage = new StringBuilder("ActivityExplorerEditor.addOverviewPage(..) _ ");
                loggerMessage.append("An error was occured at the evaluation of the predicat of page ").append(page.getId());
                loggerMessage.append(". Refer to the exception stack for more details");
                ActivityExplorerLoggerService.getInstance().log(4, loggerMessage.toString(), e);
            }
        }
        if (overviewPage != null) {
            overviewPage.initialize((FormEditor)this);
        } else {
            overviewPage = new OverviewActivityExplorerPage((FormEditor)this);
        }
        this.addPage((IFormPage)overviewPage);
    }

    protected IFormPage createDocumentationPage() {
        return new DocumentationActivityExplorerPage((FormEditor)this);
    }

    @Deprecated
    protected OverviewActivityExplorerPage getOrCreateOverviewActivityExplorerPage() {
        CommonActivityExplorerPage page;
        List<CommonActivityExplorerPage> contributedPages = ActivityExplorerExtensionManager.getAllPages();
        Collections.sort(contributedPages);
        if (!contributedPages.isEmpty() && (page = contributedPages.get(0)) instanceof OverviewActivityExplorerPage && page.getPosition() == 0) {
            page.initialize((FormEditor)this);
            return (OverviewActivityExplorerPage)page;
        }
        return new OverviewActivityExplorerPage((FormEditor)this);
    }

    public void dispose() {
        IEditorSite editorSite;
        ActivityExplorerManager.INSTANCE.removeActivityExplorerEditorListener(this);
        if (this._partListener != null) {
            ((ActivityExplorerEditorPartListener)this._partListener).dispose();
        }
        if ((editorSite = this.getEditorSite()) != null) {
            if (this._propertySheetPage != null) {
                this._propertySheetPage.dispose();
                this._propertySheetPage = null;
            }
            this.unregisterSession();
            if (this._partListener != null) {
                editorSite.getPage().removePartListener(this._partListener);
                this._partListener = null;
                ActivityExplorerActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
                super.dispose();
            }
        }
        if (this.getEditorInput() != null) {
            this.getEditorInput().dispose();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isDirty()) {
            try {
                this.getEditorInput().getSession().save((IProgressMonitor)new NullProgressMonitor());
            }
            catch (RuntimeException ite) {
                StatusManager.getManager().handle((IStatus)new Status(4, this.getBundleId(ite), ite.getMessage(), (Throwable)ite), 4);
            }
        }
    }

    private String getBundleId(Object obj) {
        Bundle bundle = FrameworkUtil.getBundle(obj.getClass());
        if (bundle != null) {
            return bundle.getSymbolicName();
        }
        return obj.getClass().getCanonicalName();
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return this.getOrCreatePropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public ActivityExplorerEditorInput getEditorInput() {
        return (ActivityExplorerEditorInput)super.getEditorInput();
    }

    private IPropertySheetPage getOrCreatePropertySheetPage() {
        if (this._propertySheetPage == null) {
            this._propertySheetPage = new TabbedPropertySheetPage(this){

                public void dispose() {
                    super.dispose();
                    ActivityExplorerEditor.this._propertySheetPage = null;
                }

                public void init(IPageSite pageSite) {
                    super.init(pageSite);
                    pageSite.setSelectionProvider(ActivityExplorerEditor.this.getEditorSite().getSelectionProvider());
                }
            };
        }
        return this._propertySheetPage;
    }

    public String getPartName() {
        return this.getEditorInput().getName();
    }

    public TabbedPropertySheetPage getPropertySheetPage() {
        return this._propertySheetPage;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getEditorSite().getPage().addPartListener(this._partListener);
    }

    public boolean isDirty() {
        Session session = this.getEditorInput().getSession();
        if (session != null) {
            return SessionStatus.DIRTY.equals((Object)session.getStatus());
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    private void unregisterSession() {
        Session session;
        ActivityExplorerEditorInput editorInput = this.getEditorInput();
        if (editorInput != null && (session = editorInput.getSession()) != null) {
            Object var2_2 = null;
        }
    }

    public Image getTitleImage() {
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        Image decoratedImage = decorator.decorateImage(super.getTitleImage(), (Object)this.getEditorInput().getSession());
        return decoratedImage;
    }

    protected void setTitleImage(Image titleImage) {
        super.setTitleImage(titleImage);
    }

    private int addNewPage(IFormPage page) {
        int index = 0;
        page.initialize((FormEditor)this);
        try {
            index = this.addPage(page);
        }
        catch (PartInitException e) {
            StringBuilder loggerMessage = new StringBuilder("ActivityExplorerEditor.addNewPage(..) _ ");
            loggerMessage.append(e.getMessage());
            ActivityExplorerLoggerService.getInstance().log(4, loggerMessage.toString(), e);
        }
        return index;
    }

    public IFormPage getPreviousPage(IFormPage current) {
        Object prev;
        ListIterator it;
        IFormPage previousPage = null;
        int i = this.pages.indexOf(current);
        if (i > -1 && (it = this.pages.listIterator(i)).hasPrevious() && (prev = it.previous()) instanceof IFormPage) {
            previousPage = (IFormPage)prev;
        }
        return previousPage;
    }

    public IFormPage getNextPage(IFormPage current) {
        Object obj;
        ListIterator it;
        IFormPage nextPage = null;
        int i = this.pages.indexOf(current);
        if (i > -1 && (it = this.pages.listIterator(i + 1)).hasNext() && (obj = it.next()) instanceof IFormPage) {
            nextPage = (IFormPage)obj;
        }
        return nextPage;
    }

    @Deprecated
    public void updateEditorPages(int activatedPage) {
        this.updateEditorPages();
    }

    protected void updateEditorPages() {
        this.removeAllPages();
        this.addPages();
        if (this.backToActivePage > 0 && this.backToActivePage < this.getPageCount()) {
            this.setActivePage(this.backToActivePage);
        } else {
            this.setActivePage(0);
        }
        this.setPartName(this.getPartName());
    }

    protected boolean doPropertyChange(PropertyChangeEvent event, boolean value, String property) {
        boolean result = false;
        if (ActivityExplorerExtensionManager.isPage(property)) {
            this.updateEditorPages(0);
            result = true;
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        boolean value = Boolean.valueOf(event.getNewValue().toString());
        if (this.doPropertyChange(event, value, property) && ActivityExplorerManager.INSTANCE.getEditor() != null) {
            ActivityExplorerManager.INSTANCE.getEditor().getActivePageInstance().getManagedForm().reflow(true);
        }
    }

    @Override
    public void executeRequest(int request, Session session) {
        block16: {
            block15: {
                ActivityExplorerEditorInput editorInput = this.getEditorInput();
                if (editorInput == null) break block15;
                Session session2 = editorInput.getSession();
                switch (request) {
                    case 8: {
                        if (session2 != null && session2.equals(session)) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    ActivityExplorerEditor.this.close(false);
                                    ActivityExplorerManager.INSTANCE.removeActivityExplorerEditorListener(ActivityExplorerEditor.this);
                                }
                            };
                            this.run(runnable);
                            break;
                        }
                        break block16;
                    }
                    case 0: {
                        if (session2 != null && session2.equals(session) && session.isOpen()) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    ActivityExplorerEditor.this.updateEditorPages();
                                }
                            };
                            this.run(runnable);
                            break;
                        }
                        break block16;
                    }
                    case 10: {
                        if (session2 != null && session2.equals(session) && session.isOpen()) {
                            this._editorDirtyStateChanged();
                            break;
                        }
                        break block16;
                    }
                    case 7: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 11: {
                        if (session2 != null && session2.equals(session) && session.isOpen()) {
                            this._editorDirtyStateChanged();
                            break;
                        }
                        break block16;
                    }
                    case 5: {
                        if (session2 == null || !session2.equals(session) || !session.isOpen()) break block16;
                        this._editorDirtyStateChanged();
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block16;
            }
            ActivityExplorerManager.INSTANCE.removeActivityExplorerEditorListener(this);
        }
    }

    private void _editorDirtyStateChanged() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IManagedForm headerForm = ActivityExplorerEditor.this.getHeaderForm();
                if (headerForm != null) {
                    headerForm.dirtyStateChanged();
                }
            }
        };
        this.run(runnable);
    }

    protected void run(Runnable runnable) {
        if (runnable != null) {
            Display display = Display.getCurrent();
            if (display == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }
}

