/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.core;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.addon.validation.core.Constraint;
import org.eclipse.viatra.addon.validation.core.Entry;
import org.eclipse.viatra.addon.validation.core.api.IEntry;
import org.eclipse.viatra.addon.validation.core.api.IViolation;
import org.eclipse.viatra.addon.validation.core.listeners.ViolationListener;
import org.eclipse.viatra.addon.validation.core.violationkey.CompositeSymmetricViolationKey;
import org.eclipse.viatra.addon.validation.core.violationkey.ViolationKey;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;

public class Violation
implements IViolation {
    private Constraint constraint;
    private String message;
    private Map<String, Object> keyObjects;
    private Map<ViolationKey, IPatternMatch> matches = new HashMap<ViolationKey, IPatternMatch>();
    private Set<ViolationListener> listeners = new HashSet<ViolationListener>();

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    protected void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Map<String, Object> getKeyObjects() {
        return this.keyObjects;
    }

    protected void setKeyObjects(Map<String, Object> keyObjects) {
        this.keyObjects = keyObjects;
    }

    protected Map<ViolationKey, IPatternMatch> getMatches() {
        return this.matches;
    }

    protected boolean addMatch(IPatternMatch match) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String name : match.parameterNames()) {
            parameters.put(name, match.get(name));
        }
        HashSet<List<String>> symmetrics = new HashSet<List<String>>();
        symmetrics.addAll(this.constraint.getSpecification().getSymmetricKeyNames());
        symmetrics.addAll(this.constraint.getSpecification().getSymmetricPropertyNames());
        CompositeSymmetricViolationKey key = new CompositeSymmetricViolationKey(parameters, symmetrics);
        if (!this.matches.containsKey(key)) {
            this.matches.put(key, match);
            return true;
        }
        return false;
    }

    protected boolean removeMatch(IPatternMatch match) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String name : match.parameterNames()) {
            parameters.put(name, match.get(name));
        }
        HashSet<List<String>> symmetrics = new HashSet<List<String>>();
        symmetrics.addAll(this.constraint.getSpecification().getSymmetricKeyNames());
        symmetrics.addAll(this.constraint.getSpecification().getSymmetricPropertyNames());
        CompositeSymmetricViolationKey key = new CompositeSymmetricViolationKey(parameters, symmetrics);
        return this.matches.remove(key) != null;
    }

    @Override
    public Set<IEntry> getEntries() {
        HashSet<IEntry> entries = new HashSet<IEntry>();
        for (Map.Entry<ViolationKey, IPatternMatch> entry : this.matches.entrySet()) {
            entries.add(new Entry(this, entry.getValue()));
        }
        return entries;
    }

    @Override
    public Set<Object> getValuesOfProperty(String propertyName) {
        HashSet<Object> propertyValues = new HashSet<Object>();
        for (Map.Entry<ViolationKey, IPatternMatch> entry : this.matches.entrySet()) {
            propertyValues.add(entry.getValue().get(propertyName));
        }
        return propertyValues;
    }

    public Set<ViolationListener> getListeners() {
        return ImmutableSet.copyOf(this.listeners);
    }

    @Override
    public boolean addListener(ViolationListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ViolationListener listener) {
        return this.listeners.remove(listener);
    }

    protected void notifyListenersViolationEntryAppeared(IPatternMatch match) {
        for (ViolationListener listener : this.listeners) {
            listener.violationEntryAppeared(this, new Entry(this, match));
        }
    }

    protected void notifyListenersViolationMessageUpdated() {
        for (ViolationListener listener : this.listeners) {
            listener.violationMessageUpdated(this);
        }
    }

    protected void notifyListenersViolationEntryDisappeared(IPatternMatch match) {
        for (ViolationListener listener : this.listeners) {
            listener.violationEntryDisappeared(this, new Entry(this, match));
        }
    }
}

