/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.modelingproject.manager.AttachSemanticResourcesJob;
import org.eclipse.sirius.business.internal.modelingproject.manager.InitializeModelingProjectJob;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener.IModelingProjectResourceListener;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener.ResourceDeltaVisitor;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.InvalidModelingProjectMarkerUpdaterJob;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

public class DefaultModelingProjectResourceListener
implements IModelingProjectResourceListener {
    @Override
    public void init() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                ResourceDeltaVisitor visitor = this.getResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                for (IProject projectToInitialize : visitor.projectsToInitialize) {
                    InitializeModelingProjectJob job = new InitializeModelingProjectJob((List)Lists.newArrayList((Object[])new IProject[]{projectToInitialize}));
                    job.setForceInit(true);
                    job.setPriority(20);
                    job.setRule((ISchedulingRule)projectToInitialize);
                    job.schedule();
                }
                if (!visitor.projectsToInitializeAndLoad.isEmpty()) {
                    for (ModelingProject modelingProject : visitor.projectsToInitializeAndLoad) {
                        try {
                            Option mainRepresentationsFileURIOption = modelingProject.getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor(), true, true);
                            if (!mainRepresentationsFileURIOption.some()) continue;
                            URI mainRepresentationsFileURI = (URI)mainRepresentationsFileURIOption.get();
                            ModelingProjectManager.INSTANCE.loadAndOpenRepresentationsFile(mainRepresentationsFileURI, true);
                        }
                        catch (IllegalArgumentException e) {
                            IProject project = modelingProject.getProject();
                            InvalidModelingProjectMarkerUpdaterJob invalidModelingProjectMarkerUpdaterJob = new InvalidModelingProjectMarkerUpdaterJob(project, e.getMessage());
                            invalidModelingProjectMarkerUpdaterJob.schedule();
                        }
                    }
                }
                if (!visitor.semanticResourcesURIsToAttachPerSession.isEmpty()) {
                    AttachSemanticResourcesJob attachSemanticResourcesJob = new AttachSemanticResourcesJob(new LinkedHashMap<Session, Set<URI>>(visitor.semanticResourcesURIsToAttachPerSession));
                    attachSemanticResourcesJob.schedule();
                    visitor.semanticResourcesURIsToAttachPerSession.clear();
                }
            }
            catch (Exception e) {
                SiriusEditPlugin.getPlugin().log(e);
            }
        }
    }

    protected ResourceDeltaVisitor getResourceDeltaVisitor() {
        return new ResourceDeltaVisitor();
    }
}

