/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class EclipseLogAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String BUNDLE_ID = "org.eclipse.m2e.logback.appender";
    private Bundle self;

    protected void append(ILoggingEvent logEvent) {
        int severity = 0;
        switch (logEvent.getLevel().levelInt) {
            case 40000: {
                severity = 4;
                break;
            }
            case 30000: {
                severity = 2;
                break;
            }
            case 20000: {
                severity = 1;
                break;
            }
            default: {
                return;
            }
        }
        Status status = new Status(severity, BUNDLE_ID, logEvent.getFormattedMessage(), this.getThrowable(logEvent));
        ILog eclipseLog = Platform.getLog((Bundle)this.getSelfBundle());
        eclipseLog.log((IStatus)status);
    }

    private Bundle getSelfBundle() {
        if (this.self == null) {
            this.self = Platform.getBundle((String)BUNDLE_ID);
        }
        return this.self;
    }

    private Throwable getThrowable(ILoggingEvent logEvent) {
        if (logEvent.getThrowableProxy() instanceof ThrowableProxy) {
            return ((ThrowableProxy)logEvent.getThrowableProxy()).getThrowable();
        }
        Object[] args = logEvent.getArgumentArray();
        if (args == null || args.length == 0) {
            return null;
        }
        Object lastObject = args[args.length - 1];
        if (lastObject instanceof Throwable) {
            return (Throwable)lastObject;
        }
        return null;
    }
}

