/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.ecore.ui.internal.custom.linkscount;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.query.java.core.IJavaQuery3;
import org.eclipse.emf.facet.query.java.core.IParameterValueList2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinksCountQuery
implements IJavaQuery3<EObject, String> {
    public String evaluate(EObject source, IParameterValueList2 parameterValues, IFacetManager facetManager, DerivedTypedElement feature) throws DerivedTypedElementException {
        try {
            ETypedElement sfParam;
            String size = "";
            if (parameterValues != null && (sfParam = (ETypedElement)parameterValues.getParameterValueByName("eStructuralFeature").getValue()) instanceof EReference) {
                size = LinksCountQuery.getSizeForReference(source, facetManager, sfParam);
            }
            return String.valueOf((String)facetManager.getSuperValueOf(feature, source, (List)parameterValues, String.class)) + size;
        }
        catch (Exception e) {
            throw new DerivedTypedElementException((Throwable)e);
        }
    }

    private static String getSizeForReference(EObject source, IFacetManager facetManager, ETypedElement sfParam) throws FacetManagerException {
        String size = "";
        Object object = facetManager.getOrInvoke(source, sfParam, Object.class);
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            int listSize = collection.size();
            if (listSize > 0) {
                size = String.format(" (%d)", listSize);
            }
        } else if (object != null) {
            size = " (1)";
        }
        return size;
    }
}

