/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.actions.BaseCommandHandler;
import org.eclipse.cft.server.ui.internal.wizards.OrgsAndSpacesWizard;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;

public class CloneServerCommand
extends BaseCommandHandler {
    private IWorkbenchPart activePart;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CloudFoundryServer cloudServer;
        this.initializeSelection(event);
        this.activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        String error = null;
        CloudFoundryServer cloudFoundryServer = cloudServer = this.selectedServer != null ? (CloudFoundryServer)this.selectedServer.loadAdapter(CloudFoundryServer.class, null) : null;
        if (this.selectedServer == null) {
            error = "No Cloud Foundry server instance available to run the selected action.";
        }
        if (error == null) {
            this.doRun(cloudServer);
        } else {
            CloudFoundryPlugin.logError((String)error);
        }
        return null;
    }

    private String getJobName() {
        return "Cloning server to selected space";
    }

    public void doRun(final CloudFoundryServer cloudServer) {
        Shell shell;
        Shell shell2 = shell = this.activePart != null && this.activePart.getSite() != null ? this.activePart.getSite().getShell() : CFUiUtil.getShell();
        if (shell != null) {
            UIJob job = new UIJob(this.getJobName()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    OrgsAndSpacesWizard wizard = new OrgsAndSpacesWizard(cloudServer);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.open();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            CloudFoundryPlugin.logError((String)"Unable to find an active shell to open the orgs and spaces wizard.");
        }
    }
}

