/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image.plugin;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.ImageResource;

public final class BundleImageResource
extends ImageResource {
    private final URL m_url;
    private final String m_symbolicName;
    private final String m_imagePath;
    private final String m_name;
    private ImageInfo m_imageInfo;

    public BundleImageResource(URL url, String symbolicName) {
        this.m_url = url;
        this.m_symbolicName = symbolicName;
        this.m_imagePath = this.m_url.getFile();
        this.m_name = StringUtils.substringAfterLast((String)this.m_imagePath, (String)"/");
    }

    public ImageInfo getImageInfo() {
        if (this.m_imageInfo == null) {
            Image image;
            try (InputStream stream = this.m_url.openStream();){
                image = new Image((Device)Display.getCurrent(), stream);
            }
            catch (Throwable e) {
                return null;
            }
            this.m_imageInfo = new ImageInfo("PLUGIN", (Object)new String[]{this.m_symbolicName, this.m_imagePath}, image, -1L);
        }
        return this.m_imageInfo;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        return this.m_imagePath;
    }

    public void dispose() {
        if (this.m_imageInfo != null) {
            this.m_imageInfo.getImage().dispose();
        }
    }
}

