/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.gef.core.tools.SelectEditPartTracker;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.gef.part.menu.MenuImageFigure;
import org.eclipse.wb.internal.core.gef.part.menu.MenuObjectEditPart;
import org.eclipse.wb.internal.core.gef.part.menu.MenuPopupEditPart;
import org.eclipse.wb.internal.core.gef.policy.menu.MenuLayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.menu.MenuSelectionEditPolicy;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;

public class MenuEditPart
extends MenuObjectEditPart {
    public static final Point TOP_LOCATION = EnvironmentUtils.IS_MAC ? new Point(20, 28) : new Point(20, 20);
    private final IMenuInfo m_menu;

    public MenuEditPart(Object toolkitModel, IMenuInfo menu) {
        super(toolkitModel, menu);
        this.m_menu = menu;
    }

    public IMenuInfo getMenu() {
        return this.m_menu;
    }

    @Override
    protected IFigure createFigure() {
        if (this.isStandaloneMenu()) {
            return new MenuImageFigure(this.m_menu);
        }
        if (this.isSubMenu()) {
            return new MenuImageFigure(this.m_menu);
        }
        return new Figure();
    }

    @Override
    protected void refreshVisuals() {
        if (this.isStandaloneMenu()) {
            Rectangle bounds = this.m_menu.getBounds();
            bounds = bounds.getCopy().setLocation(TOP_LOCATION);
            this.getFigure().setBounds(bounds);
        } else if (this.isSubMenu()) {
            IMenuInfo parentItemMenu;
            Dimension size = this.m_menu.getBounds().getSize();
            IFigure parentFigure = ((GraphicalEditPart)this.getParent()).getFigure();
            Rectangle parentBounds = parentFigure.getBounds().getCopy();
            FigureUtils.translateFigureToAbsolute(parentFigure, (Translatable)parentBounds);
            Point figureLocation = this.getParent() instanceof MenuPopupEditPart ? parentBounds.getBottomLeft() : (this.getParent().getParent() instanceof MenuEditPart ? ((parentItemMenu = ((MenuEditPart)this.getParent().getParent()).m_menu).isHorizontal() ? parentBounds.getBottomLeft() : parentBounds.getTopRight().getTranslated(-3, -2)) : parentBounds.getTopRight().getTranslated(-3, -2));
            this.getFigure().setBounds(new Rectangle(figureLocation, size));
        } else {
            this.getFigure().setBounds(this.m_menu.getBounds());
        }
    }

    private boolean isStandaloneMenu() {
        return false;
    }

    protected final boolean isSubMenu() {
        return this.getParent() instanceof MenuObjectEditPart;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new MenuLayoutEditPolicy(this.m_menu));
        this.installEditPolicy("Selection Feedback", (EditPolicy)new MenuSelectionEditPolicy());
    }

    @Override
    public Tool getDragTracker(Request request) {
        if (this.isSubMenu()) {
            return new SelectEditPartTracker((EditPart)this);
        }
        return super.getDragTracker(request);
    }

    @Override
    protected List<?> getModelChildren() {
        ArrayList<Object> modelItems = new ArrayList<Object>();
        for (IMenuItemInfo menuItem : this.m_menu.getItems()) {
            modelItems.add(menuItem.getModel());
        }
        return modelItems;
    }
}

