/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.legend;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.menu.legend.AbstractMenuListener;
import org.eclipse.swtchart.extensions.menu.legend.Messages;

public class SetDescriptionAction
extends AbstractMenuListener {
    public SetDescriptionAction(SeriesListUI seriesListUI) {
        super(seriesListUI);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(){

            public String getText() {
                return Messages.getString("SET_DESCRIPTION");
            }

            public String getToolTipText() {
                return Messages.getString("setDescriptionForSelectedSeries");
            }

            public void run() {
                BaseChart baseChart = SetDescriptionAction.this.getBaseChart();
                SeriesListUI seriesListUI = SetDescriptionAction.this.getSeriesListUI();
                Table table = seriesListUI.getTable();
                List<ISeries<?>> selectedSeries = SetDescriptionAction.this.getSelectedSeries();
                if (!selectedSeries.isEmpty()) {
                    String firstDescription = selectedSeries.get(0).getDescription();
                    InputDialog dialog = new InputDialog(table.getShell(), Messages.getString("DESCRIPTION"), Messages.getString("SET_DESCRIPTION"), firstDescription, new IInputValidator(){

                        public String isValid(String input) {
                            if (input == null) {
                                return "FORGOT_TO_SET_DESCRIPTION";
                            }
                            if ((input = input.trim()).isEmpty()) {
                                return "DESCRIPTION_MUST_NOT_BE_EMPTY";
                            }
                            return null;
                        }
                    });
                    if (dialog.open() == 0) {
                        String description = dialog.getValue();
                        for (ISeries<?> series : selectedSeries) {
                            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
                            seriesSettings.setDescription(description);
                            baseChart.applySeriesSettings(series, seriesSettings, true);
                        }
                        SetDescriptionAction.this.refresh();
                    }
                }
            }
        });
    }
}

