/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.spelling;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.ui.internal.spelling.ISpellcheckDelegate;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class SpellcheckDelegateAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{ISpellcheckDelegate.class};
    private static final ISpellcheckDelegate DELEGATE = new PHPSpellcheckDelegate();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        ISpellcheckDelegate decision = null;
        if (adaptableObject instanceof IDOMModel && ISpellcheckDelegate.class.equals((Object)adapterType)) {
            decision = DELEGATE;
        }
        return decision;
    }

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    private static class PHPSpellcheckDelegate
    implements ISpellcheckDelegate {
        private PHPSpellcheckDelegate() {
        }

        public boolean shouldSpellcheck(int offset, IStructuredModel model) {
            IStructuredDocument doc;
            if (model instanceof DOMModelForPHP && (doc = model.getStructuredDocument()) instanceof BasicStructuredDocument) {
                IStructuredDocumentRegion sdRegion = ((BasicStructuredDocument)doc).getRegionAtCharacterOffset(offset);
                try {
                    if (sdRegion != null) {
                        IPHPScriptRegion phpScriptRegion;
                        String partition;
                        ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(offset);
                        int startRegion = sdRegion.getStartOffset();
                        if (textRegion instanceof ITextRegionContainer) {
                            ITextRegionContainer container = (ITextRegionContainer)textRegion;
                            startRegion += container.getStart();
                            textRegion = container.getRegionAtCharacterOffset(offset);
                        }
                        if (textRegion instanceof IPHPScriptRegion && ((partition = (phpScriptRegion = (IPHPScriptRegion)textRegion).getPartition(offset - (startRegion += phpScriptRegion.getStart()))).equals("org.eclipse.php.PHP_QUOTED_STRING") || partition.equals("org.eclipse.php.PHP_SINGLE_LINE_COMMENT") || partition.equals("org.eclipse.php.PHP_MULTI_LINE_COMMENT") || partition.equals("org.eclipse.php.PHP_DOC"))) {
                            return true;
                        }
                    }
                    return true;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

