/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features.support;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;

public class PluginSupport {
    public IPluginModelBase toSinglePluginModel(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        return this.toPluginModel(firstElement);
    }

    public IPluginModelBase toPluginModel(Object obj) {
        if (obj instanceof IPluginModelBase) {
            return (IPluginModelBase)obj;
        }
        if (obj instanceof IFeaturePlugin) {
            IFeaturePlugin featurePlugin = (IFeaturePlugin)obj;
            return this.getManager().findModel(featurePlugin.getId());
        }
        if (obj instanceof IProductPlugin) {
            IProductPlugin productPlugin = (IProductPlugin)obj;
            return this.getManager().findModel(productPlugin.getId());
        }
        if (obj instanceof IProject) {
            return this.getManager().findModel((IProject)obj);
        }
        if (obj instanceof IJavaProject) {
            return this.getManager().findModel(((IJavaProject)obj).getProject());
        }
        return null;
    }

    public PluginModelManager getManager() {
        return PDECore.getDefault().getModelManager();
    }
}

