/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.resolution;

import aQute.bnd.osgi.Clazz;
import aQute.bnd.service.resource.SupportingResource;
import java.util.Map;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.pde.bnd.ui.model.resolution.RequirementWrapper;
import org.eclipse.pde.bnd.ui.model.resource.R5LabelFormatter;
import org.eclipse.pde.bnd.ui.model.resource.RequirementLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class RequirementWrapperLabelProvider
extends RequirementLabelProvider {
    private final StyledString.Styler resolved = StyledString.QUALIFIER_STYLER;

    public RequirementWrapperLabelProvider(boolean shortenNamespaces) {
        super(shortenNamespaces);
    }

    @Override
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof RequirementWrapper) {
            RequirementWrapper rw = (RequirementWrapper)element;
            Image icon = Resources.getImage(R5LabelFormatter.getNamespaceImagePath(rw.requirement.getNamespace()));
            cell.setImage(icon);
            StyledString label = this.getLabel(rw.requirement);
            if (rw.resolved || rw.java) {
                label.setStyle(0, label.length(), this.resolved);
            }
            cell.setText(label.getString());
            cell.setStyleRanges(label.getStyleRanges());
        } else if (element instanceof Clazz) {
            String className;
            String pkg;
            cell.setImage(Resources.getImage("class_obj"));
            String fqn = ((Clazz)element).getFQN();
            int dot = fqn.lastIndexOf(46);
            if (dot >= 0) {
                pkg = fqn.substring(0, dot);
                className = fqn.substring(dot + 1);
            } else {
                pkg = "<default package>";
                className = fqn;
            }
            StyledString label = new StyledString(className);
            label.append(" - " + pkg, StyledString.QUALIFIER_STYLER);
            cell.setText(label.getString());
            cell.setStyleRanges(label.getStyleRanges());
        }
    }

    public String getToolTipText(Object element) {
        if (element instanceof RequirementWrapper) {
            RequirementWrapper rw = (RequirementWrapper)element;
            return RequirementWrapperLabelProvider.tooltipText(rw);
        }
        return null;
    }

    static String tooltipText(RequirementWrapper rw) {
        SupportingResource sr;
        int index;
        Requirement req = rw.requirement;
        StringBuilder buf = new StringBuilder(300);
        if (rw.resolved) {
            buf.append("RESOLVED:\n");
        }
        if (rw.java) {
            buf.append("JAVA:\n");
        }
        Resource r = req.getResource();
        buf.append("FROM: ").append(r).append("\n");
        if (r instanceof SupportingResource && (index = (sr = (SupportingResource)r).getSupportingIndex()) >= 0) {
            buf.append("Requirement from a supporting resource ").append(index).append(" part of ").append(sr.getParent()).append("\n");
        }
        buf.append(req.getNamespace());
        for (Map.Entry attr : req.getAttributes().entrySet()) {
            buf.append(";\n\t").append((String)attr.getKey()).append(" = ").append(attr.getValue());
        }
        for (Map.Entry directive : req.getDirectives().entrySet()) {
            buf.append(";\n\t").append((String)directive.getKey()).append(" := ").append((String)directive.getValue());
        }
        return buf.toString();
    }
}

