/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.text.MessageFormat;
import org.eclipse.net4j.util.container.ContainerDelta;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IContainerEventVisitor;
import org.eclipse.net4j.util.event.Event;

public class SingleDeltaContainerEvent<E>
extends Event
implements IContainerEvent<E> {
    private static final long serialVersionUID = 1L;
    private IContainerDelta<E>[] deltas;

    public SingleDeltaContainerEvent(IContainer<E> container, E element, IContainerDelta.Kind kind) {
        super(container);
        this.deltas = new IContainerDelta[]{new ContainerDelta<E>(element, kind)};
    }

    @Override
    public IContainer<E> getSource() {
        return (IContainer)super.getSource();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public IContainerDelta<E>[] getDeltas() {
        return this.deltas;
    }

    @Override
    public IContainerDelta<E> getDelta() throws IllegalStateException {
        return this.deltas[0];
    }

    @Override
    public E getDeltaElement() throws IllegalStateException {
        return this.deltas[0].getElement();
    }

    @Override
    public IContainerDelta.Kind getDeltaKind() throws IllegalStateException {
        return this.deltas[0].getKind();
    }

    @Override
    public void accept(IContainerEventVisitor<E> visitor) {
        E element = this.deltas[0].getElement();
        boolean filtered = true;
        if (visitor instanceof IContainerEventVisitor.Filtered) {
            filtered = ((IContainerEventVisitor.Filtered)visitor).filter(element);
        }
        if (filtered) {
            switch (this.deltas[0].getKind()) {
                case ADDED: {
                    visitor.added(element);
                    break;
                }
                case REMOVED: {
                    visitor.removed(element);
                }
            }
        }
    }

    @Override
    public String toString() {
        return MessageFormat.format("ContainerEvent[source={0}, {1}={2}]", new Object[]{this.getSource(), this.getDeltaKind(), this.getDeltaElement()});
    }
}

