/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.io;

import java.io.Writer;

public class StringBuilderWriter
extends Writer {
    private StringBuilder sb;

    public StringBuilderWriter(StringBuilder sb) {
        if (sb == null) {
            throw new NullPointerException();
        }
        this.sb = sb;
        this.lock = sb;
    }

    public StringBuilderWriter(int initialSize) {
        this(new StringBuilder(initialSize));
    }

    public StringBuilderWriter() {
        this(new StringBuilder());
    }

    @Override
    public void write(int c) {
        this.sb.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (len != 0) {
            this.sb.append(cbuf, off, len);
        }
    }

    @Override
    public void write(String str) {
        this.sb.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.sb.append(str, off, off + len);
    }

    public StringBuilder getBuilder() {
        return this.sb;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.sb.toString();
    }
}

