/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.acceleo.aql.ide.ui.declaration.AcceleoLSBasedHyperlink;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class AcceleoOpenDeclarationHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        TextDocumentPositionParams params;
        IDocument document = textViewer.getDocument();
        if (document == null || !AcceleoOpenDeclarationHyperlinkDetector.isAcceleoDocument(document)) {
            return null;
        }
        try {
            params = LSPEclipseUtils.toTextDocumentPosistionParams((int)region.getOffset(), (IDocument)document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError((Throwable)e);
            return null;
        }
        LinkedHashMap allLinks = new LinkedHashMap();
        try {
            CompletableFuture definitions = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getDefinitionProvider)).collectAll(ls -> ls.getTextDocumentService().definition(LSPEclipseUtils.toDefinitionParams((TextDocumentPositionParams)params)).thenApply(l -> l));
            CompletableFuture typeDefinitions = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getTypeDefinitionProvider)).collectAll(ls -> ls.getTextDocumentService().typeDefinition(LSPEclipseUtils.toTypeDefinitionParams((TextDocumentPositionParams)params)).thenApply(l -> l));
            CompletableFuture implementations = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getImplementationProvider)).collectAll(ls -> ls.getTextDocumentService().implementation(LSPEclipseUtils.toImplementationParams((TextDocumentPositionParams)params)).thenApply(l -> l));
            ((List)LanguageServers.addAll((CompletableFuture)LanguageServers.addAll((CompletableFuture)definitions, (CompletableFuture)typeDefinitions), (CompletableFuture)implementations).get(800L, TimeUnit.MILLISECONDS)).stream().flatMap(locations -> AcceleoOpenDeclarationHyperlinkDetector.toHyperlinks(document, region, (Either<List<? extends Location>, List<? extends LocationLink>>)locations).stream()).forEach(link -> {
                AcceleoLSBasedHyperlink acceleoLSBasedHyperlink = allLinks.putIfAbsent(link.getLocation(), link);
            });
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError((Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning((String)"Could not detect hyperlinks due to timeout after 800 milliseconds", (Throwable)e);
        }
        if (allLinks.isEmpty()) {
            return null;
        }
        return allLinks.values().toArray(new IHyperlink[allLinks.size()]);
    }

    private static boolean isAcceleoDocument(IDocument document) {
        List contentTypes = LSPEclipseUtils.getDocumentContentTypes((IDocument)document);
        boolean foundAcceleoContentType = false;
        for (IContentType contentType : contentTypes) {
            if (!"Acceleo".equals(contentType.getName())) continue;
            foundAcceleoContentType = true;
            break;
        }
        boolean res = foundAcceleoContentType;
        return res;
    }

    private static Collection<AcceleoLSBasedHyperlink> toHyperlinks(IDocument document, IRegion region, Either<List<? extends Location>, List<? extends LocationLink>> locations) {
        ArrayList<AcceleoLSBasedHyperlink> res;
        block4: {
            block3: {
                if (locations == null) {
                    return Collections.emptyList();
                }
                res = new ArrayList<AcceleoLSBasedHyperlink>();
                if (!locations.isLeft()) break block3;
                for (Location location : (List)locations.getLeft()) {
                    res.add(new AcceleoLSBasedHyperlink(location, AcceleoOpenDeclarationHyperlinkDetector.findWord(document, region)));
                }
                break block4;
            }
            if (!locations.isRight()) break block4;
            for (LocationLink locationLink : (List)locations.getRight()) {
                res.add(new AcceleoLSBasedHyperlink(locationLink, AcceleoOpenDeclarationHyperlinkDetector.getSelectedRegion(document, region, locationLink)));
            }
        }
        return res;
    }

    private static IRegion getSelectedRegion(IDocument document, IRegion region, LocationLink locationLink) {
        Range originSelectionRange = locationLink.getOriginSelectionRange();
        if (originSelectionRange != null) {
            try {
                int offset = LSPEclipseUtils.toOffset((Position)originSelectionRange.getStart(), (IDocument)document);
                int endOffset = LSPEclipseUtils.toOffset((Position)originSelectionRange.getEnd(), (IDocument)document);
                return new Region(offset, endOffset - offset);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        return AcceleoOpenDeclarationHyperlinkDetector.findWord(document, region);
    }

    private static IRegion findWord(IDocument document, IRegion region) {
        int start = -2;
        int end = -1;
        int offset = region.getOffset();
        try {
            char c;
            int pos = offset;
            while (pos >= 0 && pos < document.getLength()) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException x) {
            LanguageServerPlugin.logWarning((String)x.getMessage(), (Throwable)x);
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return region;
    }
}

