/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.internal.transport.AbstractSocketWrapper;
import org.eclipse.wst.jsdt.chromium.util.ByteToCharConverter;

public class SocketWrapper
extends AbstractSocketWrapper<LoggableInputStream, LoggableOutputStream> {
    public SocketWrapper(SocketAddress endpoint, int connectionTimeoutMs, ConnectionLogger connectionLogger, Charset charset) throws IOException {
        super(endpoint, connectionTimeoutMs, connectionLogger, new FactoryImpl(charset));
    }

    private static class FactoryImpl
    implements AbstractSocketWrapper.WrapperFactory<LoggableInputStream, LoggableOutputStream> {
        private final Charset charset;

        FactoryImpl(Charset charset) {
            this.charset = charset;
        }

        @Override
        public LoggableInputStream wrapInputStream(final InputStream inputStream) {
            return new LoggableInputStream(){

                @Override
                public InputStream getInputStream() {
                    return inputStream;
                }

                @Override
                public void markSeparatorForLog() {
                }
            };
        }

        @Override
        public LoggableOutputStream wrapOutputStream(final OutputStream outputStream) {
            return new LoggableOutputStream(){

                @Override
                public OutputStream getOutputStream() {
                    return outputStream;
                }

                @Override
                public void markSeparatorForLog() {
                }
            };
        }

        @Override
        public LoggableInputStream wrapInputStream(LoggableInputStream loggableReader, final ConnectionLogger.StreamListener listener) {
            final InputStream originalInputStream = loggableReader.getInputStream();
            final InputStream wrappedInputStream = new InputStream(){
                private final ByteToCharConverter byteToCharConverter;
                {
                    this.byteToCharConverter = new ByteToCharConverter(factoryImpl.charset);
                }

                @Override
                public int read() throws IOException {
                    byte[] buffer = new byte[1];
                    int res = this.readImpl(buffer, 0, 1);
                    if (res <= 0) {
                        return -1;
                    }
                    return buffer[0];
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return this.readImpl(b, off, len);
                }

                private int readImpl(byte[] buf, int off, int len) throws IOException {
                    int res = originalInputStream.read(buf, off, len);
                    if (res > 0) {
                        CharBuffer charBuffer = this.byteToCharConverter.convert(ByteBuffer.wrap(buf, off, res));
                        listener.addContent(charBuffer);
                    }
                    return res;
                }
            };
            return new LoggableInputStream(){

                @Override
                public InputStream getInputStream() {
                    return wrappedInputStream;
                }

                @Override
                public void markSeparatorForLog() {
                    listener.addSeparator();
                }
            };
        }

        @Override
        public LoggableOutputStream wrapOutputStream(LoggableOutputStream originalLoggableWriter, final ConnectionLogger.StreamListener listener) {
            if (listener == null) {
                return originalLoggableWriter;
            }
            final OutputStream originalOutputStream = originalLoggableWriter.getOutputStream();
            final OutputStream wrappedOutputStream = new OutputStream(){
                private final ByteToCharConverter byteToCharConverter;
                {
                    this.byteToCharConverter = new ByteToCharConverter(factoryImpl.charset);
                }

                @Override
                public void close() throws IOException {
                    originalOutputStream.close();
                }

                @Override
                public void flush() throws IOException {
                    originalOutputStream.flush();
                }

                @Override
                public void write(int b) throws IOException {
                    originalOutputStream.write(b);
                    this.writeToListener(ByteBuffer.wrap(new byte[]{(byte)b}));
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.writeImpl(b, 0, b.length);
                }

                @Override
                public void write(byte[] buf, int off, int len) throws IOException {
                    this.writeImpl(buf, off, len);
                }

                private void writeImpl(byte[] buf, int off, int len) throws IOException {
                    originalOutputStream.write(buf, off, len);
                    this.writeToListener(ByteBuffer.wrap(buf, off, len));
                }

                private void writeToListener(ByteBuffer byteBuffer) {
                    CharBuffer charBuffer = this.byteToCharConverter.convert(byteBuffer);
                    listener.addContent(charBuffer);
                }
            };
            return new LoggableOutputStream(){

                @Override
                public OutputStream getOutputStream() {
                    return wrappedOutputStream;
                }

                @Override
                public void markSeparatorForLog() {
                    listener.addSeparator();
                }
            };
        }
    }

    public static abstract class LoggableInputStream {
        public abstract InputStream getInputStream();

        public abstract void markSeparatorForLog();
    }

    public static abstract class LoggableOutputStream {
        public abstract OutputStream getOutputStream();

        public abstract void markSeparatorForLog();
    }
}

