/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.jar.JarEntry;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.annotation.Owning;

public final class ResourceUtils {
    @Owning
    public static BufferedReader getResourceReader(Class<?> clazz, String resourceName) throws FileNotFoundException {
        return ResourceUtils.getResourceReader(clazz, resourceName, null);
    }

    @Owning
    public static BufferedReader getResourceReader(Class<?> clazz, String resourceName, @Nullable Charset charset) throws FileNotFoundException {
        InputStream is = clazz.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException("Resource not found: " + resourceName);
        }
        return new BufferedReader(new InputStreamReader(is, charset == null ? StandardCharsets.UTF_8 : charset));
    }

    public static long getResourceLastModified(Class<?> clazz, String resourceName) throws IOException {
        String protocol;
        URL url = clazz.getResource(resourceName);
        if (url == null) {
            throw new FileNotFoundException("Resource not found: " + resourceName);
        }
        switch (protocol = url.getProtocol()) {
            case "file": {
                try {
                    return new File(url.toURI()).lastModified();
                }
                catch (URISyntaxException ex) {
                    return new File(url.getFile()).lastModified();
                }
            }
            case "jar": {
                JarURLConnection jarConn = (JarURLConnection)url.openConnection();
                JarEntry entry = jarConn.getJarEntry();
                if (entry != null) {
                    long t = entry.getTime();
                    return t > 0L ? t : 0L;
                }
                return jarConn.getLastModified();
            }
        }
        return url.openConnection().getLastModified();
    }

    public static URI getResourceURI(Class<?> clazz, String resourceName) {
        URL resUrl = clazz.getResource(resourceName);
        if (resUrl != null) {
            return URI.create(resUrl.toString());
        }
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        if (cs == null) {
            throw new IllegalArgumentException("Cannot determine code source for class: " + clazz.getName());
        }
        URL csLoc = cs.getLocation();
        if (csLoc == null) {
            throw new IllegalArgumentException("Cannot determine code-source URL for class: " + clazz.getName());
        }
        resourceName = resourceName.startsWith("/") ? resourceName.substring(1) : resourceName;
        String csLocExternal = csLoc.toExternalForm();
        return switch (csLoc.getProtocol()) {
            case "file" -> {
                if (csLocExternal.endsWith(".jar")) {
                    yield URI.create((String)(csLocExternal.endsWith("!/") ? csLocExternal : csLocExternal + "!/") + resourceName);
                }
                yield URI.create((String)(csLocExternal.endsWith("/") ? csLocExternal : csLocExternal + "/") + resourceName);
            }
            case "jar" -> URI.create((String)(csLocExternal.endsWith("!/") ? csLocExternal : csLocExternal + "!/") + resourceName);
            default -> URI.create((String)(csLocExternal.endsWith("/") ? csLocExternal : csLocExternal + "/") + resourceName);
        };
    }

    private ResourceUtils() {
    }
}

