/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.BaseConnectionSettings;

public class UnixSocketConnectionSettings
extends BaseConnectionSettings {
    private final String path;

    public UnixSocketConnectionSettings(String path) {
        this.path = path != null && !path.isEmpty() && !path.matches("\\w+://.*") ? "unix://" + path : path;
    }

    @Override
    public IDockerConnectionSettings.BindingType getType() {
        return IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION;
    }

    @Override
    public Object[] getProperties() {
        return new Object[]{new Object[]{"Type", this.getType().toString()}, new Object[]{"Socket", this.getPath()}};
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasPath() {
        return this.path != null && !this.path.isEmpty();
    }

    public String toString() {
        return this.path;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnixSocketConnectionSettings other = (UnixSocketConnectionSettings)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

