/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.util;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnumLiteral;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypeParameter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.XDataType;
import org.eclipse.emf.ecore.xcore.XEnumLiteral;
import org.eclipse.emf.ecore.xcore.XNamedElement;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.XParameter;
import org.eclipse.emf.ecore.xcore.XStructuralFeature;
import org.eclipse.emf.ecore.xcore.XTypeParameter;
import org.eclipse.emf.ecore.xcore.XcoreExtensions;
import org.eclipse.emf.ecore.xcore.mappings.AbstractMapping;
import org.eclipse.emf.ecore.xcore.mappings.ToXcoreMapping;
import org.eclipse.emf.ecore.xcore.mappings.XClassMapping;
import org.eclipse.emf.ecore.xcore.mappings.XDataTypeMapping;
import org.eclipse.emf.ecore.xcore.mappings.XEnumLiteralMapping;
import org.eclipse.emf.ecore.xcore.mappings.XFeatureMapping;
import org.eclipse.emf.ecore.xcore.mappings.XOperationMapping;
import org.eclipse.emf.ecore.xcore.mappings.XPackageMapping;
import org.eclipse.emf.ecore.xcore.mappings.XParameterMapping;
import org.eclipse.emf.ecore.xcore.mappings.XTypeParameterMapping;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.xtext.xbase.lib.Extension;

public class XcoreGenModelBuilder {
    @Inject
    @Extension
    private XcoreMapper mapper;

    public GenModel getGenModel(XPackage pack) {
        EPackage ePackage = this.mapper.getMapping(pack).getEPackage();
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModel.setComplianceLevel(GenJDKLevel.JDK50_LITERAL);
        genModel.initialize(Collections.singleton(ePackage));
        pack.eResource().getContents().add(1, (Object)genModel);
        this.buildMap(genModel);
        return genModel;
    }

    public void buildMap(GenModel genModel) {
        Iterable<EObject> _allContentsIterable = XcoreExtensions.allContentsIterable((EObject)genModel);
        for (EObject genElement : _allContentsIterable) {
            ToXcoreMapping _toXcoreMapping;
            AbstractMapping _mapping;
            XNamedElement _xcoreElement;
            boolean _matched = false;
            if (genElement instanceof GenPackage) {
                _matched = true;
                _xcoreElement = this.mapper.getToXcoreMapping((EObject)((GenPackage)genElement).getEcorePackage()).getXcoreElement();
                XPackage xPackage = (XPackage)_xcoreElement;
                if (xPackage != null) {
                    _mapping = this.mapper.getMapping(xPackage);
                    ((XPackageMapping)_mapping).setGenPackage((GenPackage)genElement);
                    _toXcoreMapping = this.mapper.getToXcoreMapping(genElement);
                    _toXcoreMapping.setXcoreElement(xPackage);
                }
            }
            if (!_matched && genElement instanceof GenClass) {
                _matched = true;
                _xcoreElement = this.mapper.getToXcoreMapping((EObject)((GenClass)genElement).getEcoreClass()).getXcoreElement();
                XClass xClass = (XClass)_xcoreElement;
                if (xClass != null) {
                    _mapping = this.mapper.getMapping(xClass);
                    ((XClassMapping)_mapping).setGenClass((GenClass)genElement);
                    _toXcoreMapping = this.mapper.getToXcoreMapping(genElement);
                    _toXcoreMapping.setXcoreElement(xClass);
                }
            }
            if (!_matched && genElement instanceof GenDataType) {
                _matched = true;
                _xcoreElement = this.mapper.getToXcoreMapping((EObject)((GenDataType)genElement).getEcoreDataType()).getXcoreElement();
                XDataType xDataType = (XDataType)_xcoreElement;
                if (xDataType != null) {
                    _mapping = this.mapper.getMapping(xDataType);
                    ((XDataTypeMapping)_mapping).setGenDataType((GenDataType)genElement);
                    _toXcoreMapping = this.mapper.getToXcoreMapping(genElement);
                    _toXcoreMapping.setXcoreElement(xDataType);
                }
            }
            if (!_matched && genElement instanceof GenFeature) {
                _matched = true;
                _xcoreElement = this.mapper.getToXcoreMapping((EObject)((GenFeature)genElement).getEcoreFeature()).getXcoreElement();
                XStructuralFeature xFeature = (XStructuralFeature)_xcoreElement;
                if (xFeature != null) {
                    _mapping = this.mapper.getMapping(xFeature);
                    ((XFeatureMapping)_mapping).setGenFeature((GenFeature)genElement);
                    _toXcoreMapping = this.mapper.getToXcoreMapping(genElement);
                    _toXcoreMapping.setXcoreElement(xFeature);
                }
            }
            if (!_matched && genElement instanceof GenOperation) {
                _matched = true;
                _xcoreElement = this.mapper.getToXcoreMapping((EObject)((GenOperation)genElement).getEcoreOperation()).getXcoreElement();
                XOperation xOperation = (XOperation)_xcoreElement;
                if (xOperation != null) {
                    _mapping = this.mapper.getMapping(xOperation);
                    ((XOperationMapping)_mapping).setGenOperation((GenOperation)genElement);
                    _toXcoreMapping = this.mapper.getToXcoreMapping(genElement);
                    _toXcoreMapping.setXcoreElement(xOperation);
                }
            }
            if (!_matched && genElement instanceof GenParameter) {
                _matched = true;
                _xcoreElement = this.mapper.getToXcoreMapping((EObject)((GenParameter)genElement).getEcoreParameter()).getXcoreElement();
                XParameter xParameter = (XParameter)_xcoreElement;
                if (xParameter != null) {
                    _mapping = this.mapper.getMapping(xParameter);
                    ((XParameterMapping)_mapping).setGenParameter((GenParameter)genElement);
                    _toXcoreMapping = this.mapper.getToXcoreMapping(genElement);
                    _toXcoreMapping.setXcoreElement(xParameter);
                }
            }
            if (!_matched && genElement instanceof GenTypeParameter) {
                _matched = true;
                _xcoreElement = this.mapper.getToXcoreMapping((EObject)((GenTypeParameter)genElement).getEcoreTypeParameter()).getXcoreElement();
                XTypeParameter xTypeParameter = (XTypeParameter)_xcoreElement;
                if (xTypeParameter != null) {
                    _mapping = this.mapper.getMapping(xTypeParameter);
                    ((XTypeParameterMapping)_mapping).setGenTypeParameter((GenTypeParameter)genElement);
                    _toXcoreMapping = this.mapper.getToXcoreMapping(genElement);
                    _toXcoreMapping.setXcoreElement(xTypeParameter);
                }
            }
            if (_matched || !(genElement instanceof GenEnumLiteral)) continue;
            _matched = true;
            _xcoreElement = this.mapper.getToXcoreMapping((EObject)((GenEnumLiteral)genElement).getEcoreEnumLiteral()).getXcoreElement();
            XEnumLiteral xEnumLiteral = (XEnumLiteral)_xcoreElement;
            if (xEnumLiteral == null) continue;
            _mapping = this.mapper.getMapping(xEnumLiteral);
            ((XEnumLiteralMapping)_mapping).setGenEnumLiteral((GenEnumLiteral)genElement);
            _toXcoreMapping = this.mapper.getToXcoreMapping(genElement);
            _toXcoreMapping.setXcoreElement(xEnumLiteral);
        }
    }

    public void initializeUsedGenPackages(GenModel genModel) {
        LinkedHashSet<EPackage> referencedEPackages = new LinkedHashSet<EPackage>();
        UniqueEList ePackages = new UniqueEList();
        EList _genPackages = genModel.getGenPackages();
        for (GenPackage genPackage : _genPackages) {
            EPackage ePackage = genPackage.getEcorePackage();
            if (ePackage == null) continue;
            ePackages.add(genPackage.getEcorePackage());
        }
        int i = 0;
        while (i < ePackages.size()) {
            EPackage ePackage = (EPackage)ePackages.get(i);
            ++i;
            TreeIterator allContents = ePackage.eAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (eObject instanceof EPackage) {
                    allContents.prune();
                    continue;
                }
                EList _eCrossReferences = eObject.eCrossReferences();
                for (EObject eCrossReference : _eCrossReferences) {
                    boolean _add;
                    EPackage referencedEPackage;
                    boolean _matched = false;
                    if (eCrossReference instanceof EClassifier) {
                        boolean _add2;
                        _matched = true;
                        EPackage referencedEPackage2 = ((EClassifier)eCrossReference).getEPackage();
                        if (referencedEPackage2 != null && (_add2 = ePackages.add(referencedEPackage2))) {
                            referencedEPackages.add(referencedEPackage2);
                        }
                    }
                    if (_matched || !(eCrossReference instanceof EStructuralFeature)) continue;
                    _matched = true;
                    EClass eContainingClass = ((EStructuralFeature)eCrossReference).getEContainingClass();
                    if (eContainingClass == null || (referencedEPackage = eContainingClass.getEPackage()) == null || !(_add = ePackages.add(referencedEPackage))) continue;
                    referencedEPackages.add(referencedEPackage);
                }
            }
        }
        for (EPackage referencedEPackage : referencedEPackages) {
            GenBase _gen;
            GenPackage usedGenPackage = genModel.findGenPackage(referencedEPackage);
            if (usedGenPackage == null && (usedGenPackage = (GenPackage)(_gen = this.mapper.getGen(this.mapper.getToXcoreMapping((EObject)referencedEPackage).getXcoreElement()))) == null) {
                usedGenPackage = this.findLocalGenPackage(referencedEPackage);
            }
            if (usedGenPackage != null) {
                boolean _tripleNotEquals;
                Resource _eResource = usedGenPackage.eResource();
                boolean bl = _tripleNotEquals = _eResource != null;
                if (!_tripleNotEquals) continue;
                genModel.getUsedGenPackages().add((Object)usedGenPackage);
                continue;
            }
            Resource genModelResource = genModel.eResource();
            EList resources = genModelResource.getResourceSet().getResources();
            i = 0;
            boolean found = false;
            while (i < resources.size() && !found) {
                boolean _notEquals;
                Resource resource = (Resource)resources.get(i);
                boolean bl = _notEquals = !Objects.equals(resource, genModelResource);
                if (_notEquals) {
                    String fileExtension = resource.getURI().fileExtension();
                    boolean _equals = "xcore".equals(fileExtension);
                    if (_equals) {
                        EObject _get;
                        GenModel usedGenModel;
                        boolean _not;
                        EList contents = resource.getContents();
                        boolean _isEmpty = contents.isEmpty();
                        boolean bl2 = _not = !_isEmpty;
                        if (_not && (usedGenPackage = (usedGenModel = (GenModel)(_get = (EObject)resource.getContents().get(1))).findGenPackage(referencedEPackage)) != null) {
                            genModel.getUsedGenPackages().add((Object)usedGenPackage);
                            found = true;
                        }
                    } else {
                        boolean _equals_1 = "genmodel".equals(fileExtension);
                        if (_equals_1) {
                            boolean _not_1;
                            EList contents_1 = resource.getContents();
                            boolean _isEmpty_1 = contents_1.isEmpty();
                            boolean bl3 = _not_1 = !_isEmpty_1;
                            if (_not_1) {
                                EObject _get_1 = (EObject)resource.getContents().get(0);
                                GenModel usedGenModel_1 = (GenModel)_get_1;
                                usedGenModel_1.reconcile();
                                usedGenPackage = usedGenModel_1.findGenPackage(referencedEPackage);
                                if (usedGenPackage != null) {
                                    genModel.getUsedGenPackages().add((Object)usedGenPackage);
                                    found = true;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            if (found) continue;
            throw new RuntimeException("No GenPackage found for " + referencedEPackage);
        }
    }

    public GenPackage findLocalGenPackage(EPackage ePackage) {
        boolean _tripleNotEquals;
        Resource _eResource = ePackage.eResource();
        boolean bl = _tripleNotEquals = _eResource != null;
        if (_tripleNotEquals) {
            EList _contents = ePackage.eResource().getContents();
            for (EObject content : _contents) {
                GenPackage genPackage;
                if (!(content instanceof GenModel) || (genPackage = ((GenModel)content).findGenPackage(ePackage)) == null) continue;
                return genPackage;
            }
        }
        return null;
    }
}

