/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.security.LoginPeekException;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequestWithMonitoring;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;

public class OpenSessionRequest
extends CDOClientRequestWithMonitoring<CDOSessionProtocol.OpenSessionResult> {
    private final String repositoryName;
    private final int sessionID;
    private final String userID;
    private final byte[] oneTimeLoginToken;
    private final boolean loginPeek;
    private final boolean passiveUpdateEnabled;
    private final CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode;
    private final CDOCommonSession.Options.LockNotificationMode lockNotificationMode;
    private final boolean subscribed;
    private final AuthorizableOperation[] operations;

    public OpenSessionRequest(CDOClientProtocol protocol, String repositoryName, int sessionID, String userID, byte[] oneTimeLoginToken, boolean loginPeek, boolean passiveUpdateEnabled, CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode, CDOCommonSession.Options.LockNotificationMode lockNotificationMode, boolean subscribed, AuthorizableOperation[] operations) {
        super(protocol, (short)1);
        this.repositoryName = repositoryName;
        this.sessionID = sessionID;
        this.userID = userID;
        this.oneTimeLoginToken = oneTimeLoginToken;
        this.loginPeek = loginPeek;
        this.passiveUpdateEnabled = passiveUpdateEnabled;
        this.passiveUpdateMode = passiveUpdateMode;
        this.lockNotificationMode = lockNotificationMode;
        this.subscribed = subscribed;
        this.operations = operations;
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        out.writeString(this.repositoryName);
        out.writeXInt(this.sessionID);
        out.writeString(this.userID);
        out.writeByteArray(this.oneTimeLoginToken);
        out.writeBoolean(this.loginPeek);
        out.writeBoolean(this.passiveUpdateEnabled);
        out.writeEnum((Enum)this.passiveUpdateMode);
        out.writeEnum((Enum)this.lockNotificationMode);
        out.writeBoolean(this.subscribed);
        int size = this.operations == null ? 0 : this.operations.length;
        out.writeXInt(size);
        int i = 0;
        while (i < this.operations.length) {
            AuthorizableOperation operation = this.operations[i];
            operation.write((ExtendedDataOutput)out);
            ++i;
        }
    }

    @Override
    protected CDOSessionProtocol.OpenSessionResult confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        boolean loginPeekFailure = in.readBoolean();
        if (loginPeekFailure) {
            throw new LoginPeekException();
        }
        int sessionID = in.readXInt();
        if (sessionID == 0) {
            return null;
        }
        return new CDOSessionProtocol.OpenSessionResult(in, sessionID);
    }

    protected String getAdditionalInfo() {
        String info = "repository=" + this.repositoryName;
        if (this.userID != null) {
            info = String.valueOf(info) + ", userID=" + this.userID;
        }
        info = String.valueOf(info) + ", passiveUpdates=";
        info = this.passiveUpdateEnabled ? String.valueOf(info) + this.passiveUpdateMode : String.valueOf(info) + "OFF";
        info = String.valueOf(info) + ", lockNotifications=" + this.lockNotificationMode;
        info = String.valueOf(info) + ", subscribed=" + this.subscribed;
        return info;
    }
}

