/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalComma
extends CPPDependentEvaluation {
    private static final ICPPFunction[] NO_FUNCTIONS = new ICPPFunction[0];
    private final ICPPEvaluation[] fArguments;
    private ICPPFunction[] fOverloads;
    private IType fType;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;

    public EvalComma(ICPPEvaluation[] evals, IASTNode pointOfDefinition) {
        this(evals, EvalComma.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalComma(ICPPEvaluation[] evals, IBinding templateDefinition) {
        super(templateDefinition);
        this.fArguments = evals;
    }

    public ICPPEvaluation[] getArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fType != null) {
            return this.fType instanceof TypeOfDependentExpression;
        }
        return EvalComma.containsDependentType(this.fArguments);
    }

    @Override
    public boolean isValueDependent() {
        return EvalComma.containsDependentValue(this.fArguments);
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression() {
        if (!EvalComma.areAllConstantExpressions(this.fArguments)) {
            return false;
        }
        ICPPFunction[] iCPPFunctionArray = this.fOverloads;
        int n = this.fOverloads.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPFunction overload = iCPPFunctionArray[n2];
            if (!EvalComma.isNullOrConstexprFunc(overload)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalComma)) {
            return false;
        }
        EvalComma o = (EvalComma)other;
        return EvalComma.areEquivalentEvaluations(this.fArguments, o.fArguments);
    }

    public ICPPFunction[] getOverloads() {
        if (this.fOverloads == null) {
            this.fOverloads = this.computeOverloads();
        }
        return this.fOverloads;
    }

    private ICPPFunction[] computeOverloads() {
        if (this.fArguments.length < 2) {
            return NO_FUNCTIONS;
        }
        if (this.isTypeDependent()) {
            return NO_FUNCTIONS;
        }
        ICPPFunction[] overloads = new ICPPFunction[this.fArguments.length - 1];
        ICPPEvaluation e1 = this.fArguments[0];
        int i = 1;
        while (i < this.fArguments.length) {
            ICPPEvaluation e2 = this.fArguments[i];
            ICPPFunction overload = CPPSemantics.findOverloadedOperatorComma(this.getTemplateDefinitionScope(), e1, e2);
            if (overload == null) {
                e1 = e2;
            } else {
                overloads[i - 1] = overload;
                e1 = new EvalFixed(ExpressionTypes.typeFromFunctionCall(overload), ExpressionTypes.valueCategoryFromFunctionCall(overload), IntegralValue.UNKNOWN);
                if (e1.getType() instanceof ISemanticProblem) {
                    e1 = e2;
                }
            }
            ++i;
        }
        return overloads;
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            this.fType = this.computeType();
            if (this.fType instanceof CPPBasicType) {
                this.fType = ((CPPBasicType)this.fType).clone(-1073741825);
            }
        }
        return this.fType;
    }

    private IType computeType() {
        ICPPFunction last;
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        ICPPFunction[] overloads = this.getOverloads();
        if (overloads.length > 0 && (last = overloads[overloads.length - 1]) != null) {
            return ExpressionTypes.typeFromFunctionCall(last);
        }
        return this.fArguments[this.fArguments.length - 1].getType();
    }

    @Override
    public IValue getValue() {
        ICPPFunction[] overloads = this.getOverloads();
        if (overloads.length > 0) {
            return DependentValue.create(this);
        }
        return this.fArguments[this.fArguments.length - 1].getValue();
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        ICPPFunction last;
        ICPPFunction[] overloads = this.getOverloads();
        if (overloads.length > 0 && (last = overloads[overloads.length - 1]) != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(last);
        }
        return this.fArguments[this.fArguments.length - 1].getValueCategory();
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)4);
        buffer.putInt(this.fArguments.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int len = buffer.getInt();
        ICPPEvaluation[] args = new ICPPEvaluation[len];
        int i = 0;
        while (i < args.length) {
            args[i] = buffer.unmarshalEvaluation();
            ++i;
        }
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalComma(args, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].instantiate(context, maxDepth);
            if (arg != this.fArguments[i]) {
                if (arg == EvalFixed.INCOMPLETE) {
                    return arg;
                }
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        if (args == this.fArguments) {
            return this;
        }
        return new EvalComma(args, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation[] args = this.fArguments;
        int i = 0;
        while (i < this.fArguments.length) {
            ICPPEvaluation arg = this.fArguments[i].computeForFunctionCall(record, context.recordStep());
            if (arg != this.fArguments[i]) {
                if (args == this.fArguments) {
                    args = new ICPPEvaluation[this.fArguments.length];
                    System.arraycopy(this.fArguments, 0, args, 0, this.fArguments.length);
                }
                args[i] = arg;
            }
            ++i;
        }
        if (args == this.fArguments) {
            return this;
        }
        EvalComma evalComma = new EvalComma(args, this.getTemplateDefinition());
        return evalComma;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = Integer.MAX_VALUE;
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, arg.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isNoexcept() {
        int n;
        int n2;
        Object[] objectArray;
        if (this.getOverloads() != null) {
            objectArray = this.getOverloads();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object overload = objectArray[n];
                if (overload != null && !EvalUtil.evaluateNoexceptSpecifier(overload.getType().getNoexceptSpecifier())) {
                    return false;
                }
                ++n;
            }
        }
        objectArray = this.fArguments;
        n2 = this.fArguments.length;
        n = 0;
        while (n < n2) {
            Object arg = objectArray[n];
            if (!arg.isNoexcept()) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

