/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.bundle;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.test.junit5.bundle.BundleSource;
import org.osgi.test.junit5.context.BundleContextExtension;

public class BundleArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<BundleSource> {
    private BundleSource source;

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        String headerFilter;
        BundleContext bundleContext = BundleContextExtension.getBundleContext(context);
        Stream<Bundle> bundles = Arrays.stream(bundleContext.getBundles()).filter(Objects::nonNull).filter(bundle -> (bundle.getState() & this.source.stateMask()) != 0);
        String[] symbolicNamePatterns = this.source.symbolicNamePattern();
        if (symbolicNamePatterns.length > 0) {
            List patterns = Arrays.stream(symbolicNamePatterns).map(Pattern::compile).collect(Collectors.toList());
            bundles = bundles.filter(bundle -> patterns.stream().anyMatch(pattern -> pattern.matcher(bundle.getSymbolicName()).matches()));
        }
        if (!(headerFilter = this.source.headerFilter()).isEmpty()) {
            Filter filter = bundleContext.createFilter(headerFilter);
            bundles = bundles.filter(bundle -> filter.match(bundle.getHeaders()));
        }
        return bundles.map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    public void accept(BundleSource source) {
        this.source = source;
    }
}

