/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.eclipse;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.wsdl.validation.internal.eclipse.EclipseWSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLValidator;
import org.osgi.framework.Bundle;

class WSDLValidatorPluginRegistryReader {
    protected static final String PLUGIN_ID = "org.eclipse.wst.wsdl.validation";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_NAMESPACE = "namespace";
    protected static final int WSDL_VALIDATOR = 0;
    protected static final int EXT_VALIDATOR = 1;
    protected String extensionPointId;
    protected String tagName;
    protected int validatorType;

    public WSDLValidatorPluginRegistryReader(String extensionPointId, String tagName, int validatorType) {
        this.extensionPointId = extensionPointId;
        this.tagName = tagName;
        this.validatorType = validatorType;
    }

    public void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, this.extensionPointId);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (element.getName().equals(this.tagName)) {
            String validatorClass = element.getAttribute(ATT_CLASS);
            String namespace = element.getAttribute(ATT_NAMESPACE);
            if (validatorClass != null) {
                try {
                    Bundle pluginBundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
                    if (this.validatorType == 1) {
                        EclipseWSDLValidatorDelegate delegate = new EclipseWSDLValidatorDelegate(validatorClass, pluginBundle);
                        WSDLValidator.getInstance().registerWSDLExtensionValidator(namespace, delegate);
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

