/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.EndOfLifeEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LifelineEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public final class EndOfLifeOperations {
    private EndOfLifeOperations() {
    }

    public static void showEndOfLifeFeedback(Request request, EndOfLifeEditPart endOfLifeEditPart, IGraphicalEditPart moveSource) {
        LifelineEditPart lifelineEditPart = (LifelineEditPart)endOfLifeEditPart.getParent();
        Point location = EndOfLifeOperations.getLocation(request);
        if (location == null) {
            return;
        }
        lifelineEditPart.showSourceFeedback((Request)EndOfLifeOperations.getLifelineResizeRequest(endOfLifeEditPart, lifelineEditPart, location, moveSource));
    }

    public static void eraseEndOfLifeFeedback(LifelineEditPart lep, Request request) {
        Point location = null;
        location = EndOfLifeOperations.getLocation(request);
        if (location == null) {
            return;
        }
        ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"resize");
        cbr.getMoveDelta().setY(location.y - (lep.getFigure().getBounds().y + lep.getFigure().getBounds().height));
        cbr.setEditParts((EditPart)lep);
        cbr.setLocation(location.getCopy());
        lep.eraseSourceFeedback((Request)cbr);
    }

    public static ChangeBoundsRequest getLifelineResizeRequest(Request request, EndOfLifeEditPart endOfLifeEditPart, IGraphicalEditPart moveSource) {
        Point location = EndOfLifeOperations.getLocation(request);
        if (endOfLifeEditPart.getParent() instanceof LifelineEditPart && location != null) {
            LifelineEditPart lifelineEditPart = (LifelineEditPart)endOfLifeEditPart.getParent();
            return EndOfLifeOperations.getLifelineResizeRequest(endOfLifeEditPart, lifelineEditPart, location, moveSource);
        }
        return null;
    }

    private static ChangeBoundsRequest getLifelineResizeRequest(EndOfLifeEditPart endOfLifeEditPart, LifelineEditPart lifelineEditPart, Point location, IGraphicalEditPart moveSource) {
        GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)lifelineEditPart);
        ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"resize");
        cbr.setResizeDirection(4);
        cbr.getSizeDelta().setHeight(EndOfLifeOperations.computeResizeDelta(endOfLifeEditPart, lifelineEditPart, location.y, moveSource));
        cbr.setEditParts((EditPart)lifelineEditPart);
        cbr.setLocation(location.getCopy());
        return cbr;
    }

    private static int computeResizeDelta(EndOfLifeEditPart endOfLifeEditPart, LifelineEditPart lifelineEditPart, int location, IGraphicalEditPart moveSource) {
        double zoom = GraphicalHelper.getZoom((EditPart)lifelineEditPart);
        int lifelineLocation = lifelineEditPart.getFigure().getBounds().y + lifelineEditPart.getFigure().getBounds().height;
        int eolMidSize = endOfLifeEditPart.getFigure().getBounds().height / 2;
        int feedbackRangeLimit = EndOfLifeOperations.getFeedBackRangeLimit(location, moveSource, eolMidSize, EndOfLifeOperations.getLastEventPosition(lifelineEditPart));
        return (int)((double)EndOfLifeOperations.getResizeDelta(lifelineLocation, eolMidSize, feedbackRangeLimit) * zoom);
    }

    private static int getFeedBackRangeLimit(int location, IGraphicalEditPart moveSource, int eolMidSize, int lastEventInTargetInstanceRole) {
        Rectangle sourceBbounds = moveSource.getFigure().getBounds();
        int feedbackRangeLimit = location;
        if (moveSource instanceof SequenceMessageEditPart) {
            if (feedbackRangeLimit < sourceBbounds.y) {
                feedbackRangeLimit = sourceBbounds.y;
            } else if (lastEventInTargetInstanceRole + eolMidSize > location) {
                feedbackRangeLimit = lastEventInTargetInstanceRole + eolMidSize;
            } else if (location > sourceBbounds.y + sourceBbounds.height) {
                feedbackRangeLimit = sourceBbounds.y + sourceBbounds.height;
            }
        }
        return feedbackRangeLimit;
    }

    private static int getLastEventPosition(LifelineEditPart lifelineEditPart) {
        int lastMessageInTargetInstanceRole = Integer.MIN_VALUE;
        Range occupiedRange = lifelineEditPart.getISequenceEvent().getOccupiedRange();
        if (!occupiedRange.isEmpty()) {
            lastMessageInTargetInstanceRole = occupiedRange.getUpperBound() + 5;
        }
        return lastMessageInTargetInstanceRole;
    }

    private static int getResizeDelta(int lifelineLocation, int eolMidSize, int feedbackRangeLimit) {
        int delta = feedbackRangeLimit;
        delta -= lifelineLocation;
        return delta -= eolMidSize;
    }

    private static Point getLocation(Request request) {
        ChangeBoundsRequest changeBoundsRequest;
        Point location = null;
        if (request instanceof BendpointRequest) {
            BendpointRequest bendpointRequest = (BendpointRequest)request;
            if (bendpointRequest.getLocation() != null) {
                location = bendpointRequest.getLocation().getCopy();
            }
        } else if (request instanceof ChangeBoundsRequest && (changeBoundsRequest = (ChangeBoundsRequest)request).getLocation() != null) {
            location = changeBoundsRequest.getLocation().getCopy();
        }
        return location;
    }
}

