/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtrelation.utilities;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomainAssignment;
import org.eclipse.qvtd.pivot.qvtrelation.RelationImplementation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationModel;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.TemplateVariable;
import org.eclipse.qvtd.pivot.qvtrelation.util.QVTrelationVisitor;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.utilities.QVTtemplatePrettyPrintVisitor;

public class QVTrelationPrettyPrintVisitor
extends QVTtemplatePrettyPrintVisitor
implements QVTrelationVisitor<Object> {
    public QVTrelationPrettyPrintVisitor(@NonNull PrettyPrinter context) {
        super(context);
    }

    @Override
    public Object visitDomainPattern(@NonNull DomainPattern object) {
        TemplateExp templateExpression = object.getTemplateExpression();
        if (templateExpression != null) {
            return templateExpression.accept((Visitor)this);
        }
        return super.visitPattern((Pattern)object);
    }

    @Override
    public Object visitKey(@NonNull Key object) {
        Class identifies = object.getIdentifies();
        if (identifies != null) {
            ((PrettyPrinter)this.context).appendQualifiedType((Element)identifies);
        }
        return null;
    }

    public Object visitObjectTemplateExp(@NonNull ObjectTemplateExp object) {
        ((PrettyPrinter)this.context).appendName((NamedElement)object);
        ((PrettyPrinter)this.context).append(" : ");
        ((PrettyPrinter)this.context).appendTypedMultiplicity((TypedElement)object);
        return null;
    }

    @Override
    public Object visitRelation(@NonNull Relation object) {
        ((PrettyPrinter)this.context).appendName((NamedElement)object);
        Rule asOverridden = object.getOverridden();
        if (asOverridden != null) {
            ((PrettyPrinter)this.context).append(" overrides ");
            RelationalTransformation overriddenTransformation = QVTrelationUtil.getContainingTransformation((EObject)asOverridden);
            if (overriddenTransformation != QVTrelationUtil.getContainingTransformation((EObject)object)) {
                ((PrettyPrinter)this.context).appendQualifiedType((Element)overriddenTransformation);
                ((PrettyPrinter)this.context).append("::");
            }
            ((PrettyPrinter)this.context).appendName((NamedElement)asOverridden);
        }
        ((PrettyPrinter)this.context).push("(", "");
        String prefix = null;
        for (RelationDomain domain : QVTrelationUtil.getOwnedDomains(object)) {
            for (VariableDeclaration variable : QVTrelationUtil.getRootVariables(domain)) {
                if (prefix != null) {
                    ((PrettyPrinter)this.context).next(null, prefix, " ");
                }
                ((PrettyPrinter)this.context).appendName((NamedElement)variable);
                Type type = variable.getType();
                if (type != null) {
                    ((PrettyPrinter)this.context).append(" : ");
                    ((PrettyPrinter)this.context).appendQualifiedType((Element)type);
                    ((PrettyPrinter)this.context).appendTypeMultiplicity((TypedElement)variable);
                }
                prefix = ",";
            }
        }
        ((PrettyPrinter)this.context).next("", ")", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitRelationCallExp(@NonNull RelationCallExp object) {
        EList<OCLExpression> arguments = object.getArgument();
        Relation referredRelation = object.getReferredRelation();
        ((PrettyPrinter)this.context).appendName((NamedElement)referredRelation);
        ((PrettyPrinter)this.context).push("(", "");
        String prefix = null;
        for (OCLExpression argument : arguments) {
            if (prefix != null) {
                ((PrettyPrinter)this.context).next(null, prefix, " ");
            }
            ((PrettyPrinter)this.context).precedenceVisit(argument, null);
            prefix = ",";
        }
        ((PrettyPrinter)this.context).next("", ")", "");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitRelationDomain(@NonNull RelationDomain object) {
        return super.visitDomain((Domain)object);
    }

    @Override
    public Object visitRelationDomainAssignment(@NonNull RelationDomainAssignment object) {
        return null;
    }

    @Override
    public Object visitRelationImplementation(@NonNull RelationImplementation object) {
        return null;
    }

    @Override
    public Object visitRelationModel(@NonNull RelationModel object) {
        return super.visitBaseModel((BaseModel)object);
    }

    @Override
    public Object visitRelationalTransformation(@NonNull RelationalTransformation object) {
        return super.visitTransformation((Transformation)object);
    }

    @Override
    public Object visitSharedVariable(@NonNull SharedVariable object) {
        return this.visitVariable(object);
    }

    public Object visitTemplateExp(@NonNull TemplateExp object) {
        ((PrettyPrinter)this.context).appendName((NamedElement)object);
        ((PrettyPrinter)this.context).append(" : ");
        ((PrettyPrinter)this.context).appendTypedMultiplicity((TypedElement)object);
        return null;
    }

    @Override
    public Object visitTemplateVariable(@NonNull TemplateVariable object) {
        return this.visitVariable(object);
    }
}

