/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.data.VMTypeData;
import org.eclipse.ocl.examples.debug.vm.data.VMValueData;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.request.VMVariableRequest;
import org.eclipse.ocl.examples.debug.vm.response.VMResponse;
import org.eclipse.ocl.examples.debug.vm.response.VMVariableResponse;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.Value;

public class VariableFinder {
    public static final @NonNull String CONTAINER_VARIABLE_NAME = "$container";
    protected final @NonNull VMEvaluationEnvironment fEvalEnv;
    protected final boolean fIsStoreValues;
    private @Nullable VMVariableData fTargetVar;
    private @Nullable String fRootDeclaredType;

    @Deprecated
    public static @Nullable String computeDetail(@NonNull URI variableURI, @NonNull VMEvaluationEnvironment fEvalEnv) {
        return VariableFinder.newInstance(fEvalEnv, true).computeDetail(variableURI);
    }

    public static @NonNull URI createURI(@NonNull String @NonNull [] varPath) {
        return VariableFinder.createURI(varPath, varPath.length - 1);
    }

    public static @NonNull URI createURI(@NonNull String @NonNull [] varPath, int endIndex) {
        String[] segments = new String[endIndex + 1];
        int i = 0;
        while (i < segments.length) {
            segments[i] = URI.encodeSegment((String)varPath[i], (boolean)true);
            ++i;
        }
        @NonNull URI hierarchicalURI = URI.createHierarchicalURI((String[])segments, null, null);
        return hierarchicalURI;
    }

    public static @NonNull List<EStructuralFeature> getAllFeatures(@NonNull EClass eClass) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        features.addAll((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
        Collections.sort(features, new Comparator<EStructuralFeature>(){

            @Override
            public int compare(EStructuralFeature var1, EStructuralFeature var2) {
                String n1 = var1.getName();
                String n2 = var2.getName();
                if (n1 == null) {
                    n1 = "";
                }
                if (n2 == null) {
                    n2 = "";
                }
                return n1.compareTo(n2);
            }
        });
        return features;
    }

    private static @NonNull String getOCLType(@NonNull ETypedElement feature) {
        boolean isNullFree = Ecore2AS.isNullFree((ETypedElement)feature);
        return VariableFinder.getOCLType(feature.getEType(), feature.isUnique(), feature.isOrdered(), isNullFree, feature.getLowerBound(), feature.getUpperBound());
    }

    private static @NonNull String getOCLType(@Nullable EClassifier eType, boolean isUnique, boolean isOrdered, boolean isNullFree, int lowerBound, int upperBound) {
        StringBuilder s = new StringBuilder();
        if (eType == null) {
            s.append("null");
        } else if (upperBound != 1) {
            if (isUnique) {
                s.append(isOrdered ? "OrderedSet" : "Set");
            } else {
                s.append(isOrdered ? "Sequence" : "Bag");
            }
            s.append("(");
            s.append(eType.getName());
            StringUtil.appendMultiplicity((StringBuilder)s, (long)lowerBound, (long)upperBound, (boolean)isNullFree);
            s.append(")");
        } else {
            s.append(eType.getName());
        }
        return s.toString();
    }

    public static String getRootVarName(URI variableURI) {
        if (variableURI.segmentCount() == 0) {
            throw new IllegalArgumentException();
        }
        return URI.decode((String)variableURI.segment(0));
    }

    public static @NonNull List<VMVariableData> getVariables(@NonNull VMEvaluationEnvironment evalEnv) {
        return VariableFinder.newInstance(evalEnv, false).getVariables();
    }

    private static boolean isPredefinedVar(String name, @NonNull VMEvaluationEnvironment evalEnv) {
        if (("self".equals(name) || "result".equals(name)) && evalEnv.getOperation() != null) {
            return true;
        }
        return "this".equals(name);
    }

    public static @NonNull String @NonNull [] getVariablePath(@NonNull URI variableURI) {
        @NonNull String @NonNull [] ids = new String[variableURI.segmentCount()];
        int i = 0;
        while (i < ids.length) {
            ids[i] = String.valueOf(URI.decode((String)variableURI.segment(i)));
            ++i;
        }
        return ids;
    }

    public static @NonNull VariableFinder newInstance(@NonNull VMEvaluationEnvironment vmEvaluationEnvironment, boolean isStoreValues) {
        return vmEvaluationEnvironment.createVariableFinder(isStoreValues);
    }

    public static @NonNull URI parseURI(String variableURI) throws IllegalArgumentException {
        return URI.createURI((String)variableURI);
    }

    @Deprecated
    public static VMResponse process(@NonNull VMVariableRequest request, @NonNull List<UnitLocation> stack, @NonNull VMEvaluationEnvironment vmEvaluationEnvironment) {
        return VariableFinder.newInstance(vmEvaluationEnvironment, true).process(request, stack);
    }

    private static EClass selectEClass(EClass eClass, int index) {
        EList superClasses;
        if (index > 0 && index < (superClasses = eClass.getEAllSuperTypes()).size()) {
            return (EClass)superClasses.get(index);
        }
        return eClass;
    }

    @Deprecated
    public static void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable Type optDeclaredType, @NonNull EvaluationEnvironment evalEnv) {
        String declaredTypeName = optDeclaredType != null ? optDeclaredType.toString() : null;
        VariableFinder.setValueAndType(variable, value, declaredTypeName, evalEnv);
    }

    @Deprecated
    public static void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable EClassifier optDeclaredType, @NonNull EvaluationEnvironment evalEnv) {
        String declaredTypeName = optDeclaredType != null ? optDeclaredType.getName() : null;
        VariableFinder.setValueAndType(variable, value, declaredTypeName, evalEnv);
    }

    @Deprecated
    public static void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable String declaredTypeName, @NonNull EvaluationEnvironment evalEnv) {
        VMValueData vmValue;
        VMTypeData vmType;
        if (value == null) {
            vmType = new VMTypeData(0, "OclVoid", declaredTypeName);
            vmValue = null;
        } else if (value instanceof InvalidValueException) {
            vmValue = new VMValueData(3, "invalid - " + ((InvalidValueException)((Object)value)).getMessage());
            vmType = new VMTypeData(0, "OclInvalid", declaredTypeName);
        } else if (value instanceof Resource) {
            Resource resource = (Resource)value;
            @NonNull String strVal = String.valueOf(resource.getURI());
            vmValue = new VMValueData(4, strVal, true);
            @NonNull String className = resource.getClass().getSimpleName();
            vmType = new VMTypeData(1, className, declaredTypeName);
        } else if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            EClass eClass = eObject.eClass();
            String qualifiedName = eClass != null ? String.valueOf(eClass.getEPackage().getName()) + "::" + eClass.getName() : eObject.getClass().getSimpleName();
            String strVal = String.valueOf(qualifiedName) + " @" + Integer.toHexString(System.identityHashCode(value));
            boolean hasVariables = eClass == null || !eClass.getEAllStructuralFeatures().isEmpty() || value instanceof Resource;
            vmValue = new VMValueData(1, strVal, hasVariables);
            @NonNull String className = eClass != null ? eClass.getName() : eObject.getClass().getSimpleName();
            vmType = new VMTypeData(1, className, declaredTypeName);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Class<?> javaType = value.getClass();
            StringBuilder strVal = new StringBuilder();
            if (declaredTypeName != null) {
                strVal.append(declaredTypeName);
            } else {
                strVal.append(javaType.getSimpleName());
            }
            strVal.append('[').append(collection.size()).append(']');
            String string = strVal.toString();
            vmValue = new VMValueData(2, string, !collection.isEmpty());
            @NonNull String className = javaType.getSimpleName();
            vmType = new VMTypeData(2, className, declaredTypeName);
        } else if (value instanceof CollectionValue) {
            CollectionValue collection = (CollectionValue)value;
            Class<?> javaType = value.getClass();
            StringBuilder strVal = new StringBuilder();
            if (declaredTypeName != null) {
                strVal.append(declaredTypeName);
            } else {
                strVal.append(javaType.getSimpleName());
            }
            strVal.append('[').append(collection.size()).append(']');
            String string = strVal.toString();
            vmValue = new VMValueData(2, string, collection.isEmpty() == false);
            @NonNull String className = javaType.getSimpleName();
            vmType = new VMTypeData(2, className, declaredTypeName);
        } else {
            @NonNull String valueOf = String.valueOf(value);
            if (value.getClass().equals(String.class)) {
                valueOf = "'" + valueOf + "'";
            }
            vmValue = new VMValueData(0, valueOf);
            @NonNull String className = value.getClass().getSimpleName();
            vmType = new VMTypeData(0, className, declaredTypeName);
        }
        variable.type = vmType;
        variable.value = vmValue;
    }

    public VariableFinder(@NonNull VMEvaluationEnvironment fEvalEnv, boolean isStoreValues) {
        this.fEvalEnv = fEvalEnv;
        this.fIsStoreValues = isStoreValues;
    }

    public void collectChildVars(Object root, @NonNull String @NonNull [] parentPath, @Nullable String containerType, @NonNull List<@NonNull VMVariableData> result) {
        block6: {
            Collection elements;
            String[] childPath;
            block7: {
                block5: {
                    childPath = new String[parentPath.length + 1];
                    System.arraycopy(parentPath, 0, childPath, 0, parentPath.length);
                    if (root instanceof Resource) {
                        Resource model = (Resource)root;
                        root = model.getContents();
                        containerType = "Set(EObject)";
                    }
                    if (!(root instanceof EObject)) break block5;
                    EObject eObject = (EObject)root;
                    @NonNull EClass eClass = eObject.eClass();
                    StringBuilder uriBuf = new StringBuilder();
                    List<EStructuralFeature> eAllFeatures = VariableFinder.getAllFeatures(eClass);
                    EList superClasses = eClass.getEAllSuperTypes();
                    for (EStructuralFeature feature : eAllFeatures) {
                        EClass owner = feature.getEContainingClass();
                        int index = superClasses.indexOf(owner);
                        uriBuf.append(index < 0 ? 0 : index);
                        uriBuf.append('.').append(feature.getName());
                        childPath[childPath.length - 1] = String.valueOf(uriBuf);
                        VMVariableData elementVar = this.createFeatureVar(feature, this.getValue(feature, eObject), VariableFinder.createURI(childPath).toString());
                        result.add(elementVar);
                        uriBuf.setLength(0);
                    }
                    childPath[childPath.length - 1] = CONTAINER_VARIABLE_NAME;
                    EObject value = eObject.eContainer();
                    if (value == null) {
                        value = eObject.eResource();
                    }
                    VMVariableData elementVar = this.createContainerVariable(eObject.eContainer(), VariableFinder.createURI(childPath));
                    result.add(elementVar);
                    break block6;
                }
                if (!(root instanceof Collection)) break block7;
                elements = (Collection)root;
                String elementType = "?";
                int i = 0;
                for (Object element : elements) {
                    childPath[childPath.length - 1] = String.valueOf(i);
                    VMVariableData elementVar = this.createCollectionElementVar(i, element, elementType, VariableFinder.createURI(childPath).toString());
                    result.add(elementVar);
                    ++i;
                }
                break block6;
            }
            if (!(root instanceof CollectionValue)) break block6;
            elements = (CollectionValue)root;
            String elementType = "(containerType instanceof CollectionType) ? ((CollectionType) containerType) .getElementType() : fFeatureAccessor.getStandardLibrary().getOclAny()";
            int i = 0;
            for (Object element : elements) {
                childPath[childPath.length - 1] = String.valueOf(i);
                VMVariableData elementVar = this.createCollectionElementVar(i, element, elementType, VariableFinder.createURI(childPath).toString());
                result.add(elementVar);
                ++i;
            }
        }
    }

    public @Nullable String computeDetail(@NonNull URI variableURI) {
        @NonNull String @NonNull [] variablePath = VariableFinder.getVariablePath(variableURI);
        Object valueObject = this.findStackObject(variablePath);
        try {
            return LabelUtil.getLabel((Object)valueObject);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private @NonNull VMVariableData createCollectionElementVar(int elementIndex, Object element, @Nullable String elementType, String uri) {
        String varName = "[" + elementIndex + "]";
        int kind = 6;
        return this.createVariable(varName, kind, elementType, element, uri);
    }

    protected @NonNull VMVariableData createContainerVariable(Object value, @NonNull URI uri) {
        String oclType = VariableFinder.getOCLType((ETypedElement)ClassUtil.nonNullModel((Object)EcorePackage.Literals.EOBJECT___ECONTAINER));
        return this.createVariable(CONTAINER_VARIABLE_NAME, 2, oclType, value, uri.toString());
    }

    private @NonNull VMVariableData createFeatureVar(@NonNull EStructuralFeature feature, Object value, String uri) {
        String varName = (String)ClassUtil.nonNullModel((Object)feature.getName());
        String declaredType = VariableFinder.getOCLType((ETypedElement)feature);
        int kind = 1;
        if (feature instanceof EReference) {
            kind = 2;
        }
        return this.createVariable(varName, kind, declaredType, value, uri);
    }

    private @NonNull VMVariableData createVariable(@NonNull String varName, int kind, @Nullable String declaredType, Object varObj, String uri) {
        VMVariableData result = new VMVariableData(varName, uri);
        result.kind = kind;
        this.setValueAndType(result, varObj, declaredType);
        if (this.fIsStoreValues) {
            result.valueObject = varObj;
        }
        return result;
    }

    public void find(@NonNull String @NonNull [] objectPath, boolean fetchChildVariables, @NonNull List<@NonNull VMVariableData> result) {
        if (result.contains(null)) {
            throw new IllegalArgumentException("null result variables");
        }
        try {
            Object referencedObj = this.findStackObject(objectPath);
            VMVariableData variable = this.fTargetVar;
            if (variable != null) {
                result.add(variable);
                if (fetchChildVariables) {
                    this.collectChildVars(referencedObj, objectPath, this.fRootDeclaredType, result);
                }
            }
        }
        finally {
            this.fTargetVar = null;
        }
    }

    protected Object findChildObject(Object parentObj, @Nullable String optParentDeclaredType, @NonNull String @NonNull [] varTreePath, int pathIndex) {
        Collection collection;
        URI uri = VariableFinder.createURI(varTreePath, pathIndex);
        VMVariableData childVar = null;
        Object nextObject = null;
        String nextDeclaredType = null;
        if (parentObj instanceof Resource) {
            parentObj = ((Resource)parentObj).getContents();
            nextDeclaredType = "EObject";
        }
        if (parentObj instanceof EObject) {
            String indexedPath = varTreePath[pathIndex];
            if (CONTAINER_VARIABLE_NAME.equals(indexedPath)) {
                EObject value = ((EObject)parentObj).eContainer();
                if (value == null) {
                    value = ((EObject)parentObj).eResource();
                }
                childVar = this.createContainerVariable(value, uri);
                nextObject = value;
                nextDeclaredType = VariableFinder.getOCLType((ETypedElement)ClassUtil.nonNullModel((Object)EcorePackage.Literals.EOBJECT___ECONTAINER));
            } else {
                EObject eObject = (EObject)parentObj;
                EStructuralFeature eFeature = this.findFeature((String)ClassUtil.nonNullState((Object)indexedPath), eObject.eClass());
                if (eFeature != null) {
                    Object value = this.getValue(eFeature, eObject);
                    childVar = this.createFeatureVar(eFeature, value, uri.toString());
                    nextObject = value;
                    nextDeclaredType = VariableFinder.getOCLType((ETypedElement)eFeature);
                }
            }
        } else if (parentObj instanceof Collection) {
            collection = (Collection)parentObj;
            int elementIndex = -1;
            try {
                elementIndex = Integer.parseInt(varTreePath[pathIndex]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
            if (elementIndex < 0 || elementIndex >= collection.size()) {
                throw new IllegalArgumentException();
            }
            nextDeclaredType = "OclAny";
            Object element = this.getElement(collection, elementIndex);
            childVar = this.createCollectionElementVar(elementIndex, element, nextDeclaredType, uri.toString());
            nextObject = element;
        } else if (parentObj instanceof CollectionValue) {
            collection = (CollectionValue)parentObj;
            int elementIndex = -1;
            try {
                elementIndex = Integer.parseInt(varTreePath[pathIndex]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
            if (elementIndex < 0 || elementIndex >= collection.intSize()) {
                throw new IllegalArgumentException();
            }
            nextDeclaredType = "OclAny";
            Object element = this.getElement(collection.getElements(), elementIndex);
            childVar = this.createCollectionElementVar(elementIndex, element, nextDeclaredType, uri.toString());
            nextObject = element;
        }
        int nextIndex = pathIndex + 1;
        if (nextIndex < varTreePath.length) {
            if (nextObject != null) {
                return this.findChildObject(nextObject, nextDeclaredType, varTreePath, nextIndex);
            }
            return null;
        }
        this.fTargetVar = childVar;
        return nextObject;
    }

    private @Nullable Object findStackObject(@NonNull String @NonNull [] varTreePath) {
        VMEvaluationEnvironment evalEnv;
        Object rootObj = null;
        boolean gotIt = false;
        String envVarName = (String)ClassUtil.nonNullState((Object)varTreePath[0]);
        if (envVarName.startsWith("$")) {
            Object pcObject = this.fEvalEnv.getValueOf((TypedElement)this.fEvalEnv.getPCVariable());
            evalEnv = this.fEvalEnv;
            while (evalEnv != null) {
                for (TypedElement localVariable : evalEnv.getVariables()) {
                    String varName;
                    OCLExpression oclExpression;
                    if (!(localVariable instanceof OCLExpression) || (oclExpression = (OCLExpression)localVariable).eContainer() != pcObject || !envVarName.equals(varName = VariableFinder.getTermVariableName(oclExpression))) continue;
                    rootObj = this.fEvalEnv.getValueOf(localVariable);
                    gotIt = true;
                    break;
                }
                if (gotIt) break;
                evalEnv = evalEnv.getVMParentEvaluationEnvironment();
            }
        }
        if (!gotIt) {
            HashSet variables = new HashSet();
            evalEnv = this.fEvalEnv;
            while (evalEnv != null) {
                Set localVariables = evalEnv.getVariables();
                variables.addAll(localVariables);
                if (NameUtil.getNameable((Iterable)localVariables, (String)"self") != null) break;
                evalEnv = evalEnv.getVMParentEvaluationEnvironment();
            }
            rootObj = NameUtil.getNameable(variables, (String)envVarName);
            if (rootObj instanceof Variable) {
                rootObj = this.fEvalEnv.getValueOf((TypedElement)rootObj);
                gotIt = true;
            }
        }
        this.fRootDeclaredType = this.getDeclaredType(rootObj);
        if (rootObj != null && varTreePath.length == 1) {
            String[] uri = new String[]{envVarName};
            this.fTargetVar = this.createVariable(envVarName, 0, this.fRootDeclaredType, rootObj, VariableFinder.createURI(uri).toString());
            return rootObj;
        }
        if (rootObj == null) {
            return null;
        }
        return this.findChildObject(rootObj, this.fRootDeclaredType, varTreePath, 1);
    }

    protected String getDeclaredType(Object valueObject) {
        if (valueObject instanceof EObject) {
            return ((EObject)valueObject).eClass().getName();
        }
        if (valueObject instanceof Value) {
            return ((Value)valueObject).getTypeId().toString();
        }
        return "evalEnv.getTypeOf(envVarName)";
    }

    private @Nullable Object getElement(@NonNull Collection<?> collection, int index) {
        if (collection instanceof EList) {
            EList eList = (EList)collection;
            return eList.get(index);
        }
        int curr = 0;
        for (Object object : collection) {
            if (curr++ != index) continue;
            return object;
        }
        return null;
    }

    private @Nullable EStructuralFeature findFeature(@NonNull String featureRef, EClass actualTarget) {
        String featureName;
        int classIndex;
        String actualRef = featureRef.startsWith("+") ? featureRef.substring(1) : featureRef;
        boolean isIntermediate = featureRef.length() != actualRef.length();
        try {
            int delimiterPos = actualRef.indexOf(46);
            if (delimiterPos <= 0 || delimiterPos >= actualRef.length() - 1) {
                throw new IllegalArgumentException("navigation feature: " + actualRef);
            }
            classIndex = Integer.parseInt(actualRef.substring(0, delimiterPos));
            featureName = actualRef.substring(delimiterPos + 1);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal feature reference: " + featureRef);
        }
        EClass featureOwner = VariableFinder.selectEClass(actualTarget, classIndex);
        if (featureOwner == null) {
            return null;
        }
        if (!isIntermediate) {
            return featureOwner.getEStructuralFeature(featureName);
        }
        return null;
    }

    protected static String getTermVariableName(@NonNull OCLExpression oclExpression) {
        Object eGet;
        EObject eContainer;
        EStructuralFeature eContainingFeature = oclExpression.eContainingFeature();
        if (eContainingFeature == null) {
            return null;
        }
        String varName = "$" + eContainingFeature.getName();
        if (eContainingFeature.isMany() && (eContainer = oclExpression.eContainer()) != null && (eGet = eContainer.eGet(eContainingFeature)) instanceof List) {
            int index = ((List)eGet).indexOf(oclExpression);
            varName = String.valueOf(varName) + "[" + index + "]";
        }
        return varName;
    }

    public Object getValue(EStructuralFeature feature, EObject target) {
        return this.navigateProperty(feature, null, target);
    }

    protected @Nullable VMVariableData getVariable(@NonNull TypedElement variable, @Nullable Object pcObject) {
        String varName = variable.getName();
        if (variable instanceof OCLExpression) {
            OCLExpression oclExpression = (OCLExpression)variable;
            if (oclExpression.eContainer() == pcObject && (varName = VariableFinder.getTermVariableName(oclExpression)) != null) {
                VMVariableData var = new VMVariableData(varName, null);
                var.kind = 0;
                Object value = null;
                try {
                    var.valueObject = value = this.fEvalEnv.getValueOf((TypedElement)oclExpression);
                }
                catch (Throwable e) {
                    value = e;
                }
                Type declaredType = oclExpression.getType();
                this.setValueAndType(var, value, declaredType);
                return var;
            }
        } else if (varName != null) {
            VMVariableData var = new VMVariableData(varName, null);
            if (VariableFinder.isPredefinedVar(varName, this.fEvalEnv)) {
                var.kind = 3;
            }
            Object value = null;
            try {
                var.valueObject = value = this.fEvalEnv.getValueOf(variable);
            }
            catch (Throwable e) {
                value = e;
            }
            Type declaredType = variable.getType();
            this.setValueAndType(var, value, declaredType);
            return var;
        }
        return null;
    }

    public @NonNull List<VMVariableData> getVariables() {
        ArrayList<VMVariableData> result = new ArrayList<VMVariableData>();
        Object pcObject = this.fEvalEnv.getValueOf((TypedElement)this.fEvalEnv.getPCVariable());
        for (TypedElement variable : this.fEvalEnv.getVariables()) {
            VMVariableData var;
            if (variable == null || (var = this.getVariable(variable, pcObject)) == null) continue;
            result.add(var);
        }
        return result;
    }

    public Object navigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) throws IllegalArgumentException {
        EStructuralFeature resolvedProperty = property;
        try {
            return this.superNavigateProperty(resolvedProperty, qualifiers, target);
        }
        catch (IllegalArgumentException e) {
            this.fEvalEnv.throwVMException(new VMRuntimeException("Unknown property '" + property.getName() + "'", e));
            return ValueUtil.INVALID_VALUE;
        }
    }

    public @Nullable VMResponse process(@NonNull VMVariableRequest request, @NonNull List<UnitLocation> stack) {
        VMVariableData variable0;
        UnitLocation location = VMVirtualMachine.lookupEnvironmentByID(request.frameID, stack);
        if (location == null) {
            return VMResponse.createERROR();
        }
        String variableURIStr = request.variableURI;
        URI variableURI = VariableFinder.parseURI(variableURIStr);
        @NonNull String @NonNull [] variablePath = VariableFinder.getVariablePath(variableURI);
        ArrayList<@NonNull VMVariableData> variables = new ArrayList<VMVariableData>();
        this.find(variablePath, request.includeChildVars, variables);
        if (variables.isEmpty()) {
            return VMResponse.createERROR();
        }
        VMVariableData[] children = null;
        int size = variables.size();
        if (size > 1) {
            children = variables.subList(1, size).toArray(new VMVariableData[size - 1]);
        }
        return (variable0 = (VMVariableData)variables.get(0)) != null ? new VMVariableResponse(variable0, children) : null;
    }

    public void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable Type optDeclaredType) {
        String declaredTypeName = optDeclaredType != null ? optDeclaredType.toString() : null;
        this.setValueAndType(variable, value, declaredTypeName);
    }

    public void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable String declaredTypeName) {
        VMValueData vmValue;
        VMTypeData vmType;
        if (value == null) {
            vmType = new VMTypeData(0, "OclVoid", declaredTypeName);
            vmValue = null;
        } else if (value instanceof InvalidValueException) {
            vmValue = new VMValueData(3, "invalid - " + ((InvalidValueException)((Object)value)).getMessage());
            vmType = new VMTypeData(0, "OclInvalid", declaredTypeName);
        } else if (value instanceof Resource) {
            Resource resource = (Resource)value;
            @NonNull String strVal = String.valueOf(resource.getURI());
            vmValue = new VMValueData(4, strVal, true);
            @NonNull String className = resource.getClass().getSimpleName();
            vmType = new VMTypeData(1, className, declaredTypeName);
        } else if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            EClass eClass = eObject.eClass();
            String qualifiedName = eClass != null ? String.valueOf(eClass.getEPackage().getName()) + "::" + eClass.getName() : eObject.getClass().getSimpleName();
            String strVal = String.valueOf(qualifiedName) + " @" + Integer.toHexString(System.identityHashCode(value));
            boolean hasVariables = eClass == null || !eClass.getEAllStructuralFeatures().isEmpty() || value instanceof Resource;
            vmValue = new VMValueData(1, strVal, hasVariables);
            @NonNull String className = eClass != null ? eClass.getName() : eObject.getClass().getSimpleName();
            vmType = new VMTypeData(1, className, declaredTypeName);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Class<?> javaType = value.getClass();
            StringBuilder strVal = new StringBuilder();
            if (declaredTypeName != null) {
                strVal.append(declaredTypeName);
            } else {
                strVal.append(javaType.getSimpleName());
            }
            strVal.append('[').append(collection.size()).append(']');
            String string = strVal.toString();
            vmValue = new VMValueData(2, string, !collection.isEmpty());
            @NonNull String className = javaType.getSimpleName();
            vmType = new VMTypeData(2, className, declaredTypeName);
        } else if (value instanceof CollectionValue) {
            CollectionValue collection = (CollectionValue)value;
            Class<?> javaType = value.getClass();
            StringBuilder strVal = new StringBuilder();
            if (declaredTypeName != null) {
                strVal.append(declaredTypeName);
            } else {
                strVal.append(javaType.getSimpleName());
            }
            strVal.append('[').append(collection.size()).append(']');
            String string = strVal.toString();
            vmValue = new VMValueData(2, string, collection.isEmpty() == false);
            @NonNull String className = javaType.getSimpleName();
            vmType = new VMTypeData(2, className, declaredTypeName);
        } else {
            @NonNull String valueOf = String.valueOf(value);
            if (value.getClass().equals(String.class)) {
                valueOf = "'" + valueOf + "'";
            }
            vmValue = new VMValueData(0, valueOf);
            @NonNull String className = value.getClass().getSimpleName();
            vmType = new VMTypeData(0, className, declaredTypeName);
        }
        variable.type = vmType;
        variable.value = vmValue;
    }

    public Object superNavigateProperty(EStructuralFeature property, List<?> qualifiers, Object target) throws IllegalArgumentException {
        EObject etarget;
        if (target instanceof EObject && (etarget = (EObject)target).eClass().getEAllStructuralFeatures().contains((Object)property)) {
            if (property.getEType() instanceof VoidType) {
                return null;
            }
            return etarget.eGet(property);
        }
        throw new IllegalArgumentException();
    }
}

