/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.util.concurrent.CountDownLatch;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.WrappedException;

public abstract class AsyncWriter
extends PipedWriter {
    private CountDownLatch latch = new CountDownLatch(1);

    public AsyncWriter() throws IOException {
        final PipedReader in = new PipedReader(this);
        Thread thread = new Thread("AsyncWriter"){

            @Override
            public void run() {
                try {
                    try {
                        AsyncWriter.this.asyncWrite(in);
                    }
                    catch (IOException ex) {
                        OM.LOG.error(ex);
                        throw WrappedException.wrap(ex);
                    }
                }
                finally {
                    AsyncWriter.this.latch.countDown();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap(ex);
        }
    }

    protected abstract void asyncWrite(Reader var1) throws IOException;
}

