/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;

public final class PluginUtil {
    private static final String ATT_CLASS = "class";
    private static final String ATT_PREDECESSOR = "predecessor";

    private PluginUtil() {
    }

    public static <T> T instantiate(IConfigurationElement element) {
        return PluginUtil.instantiate(element, ATT_CLASS);
    }

    public static <T> T instantiate(IConfigurationElement element, String classAttribute) {
        try {
            Object extension = element.createExecutableExtension(classAttribute);
            return (T)extension;
        }
        catch (CoreException ex) {
            throw WrappedException.wrap((Exception)((Object)ex));
        }
    }

    public static IConfigurationElement[] getConfigurationElements(String namespace, String extensionPointName) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return registry.getConfigurationElementsFor(namespace, extensionPointName);
    }

    public static IConfigurationElement[] removePredecessors(IConfigurationElement[] elements) {
        return PluginUtil.removePredecessors(elements, ATT_CLASS, ATT_PREDECESSOR);
    }

    public static IConfigurationElement[] removePredecessors(IConfigurationElement[] elements, String classAttribute, String predecessorAttribute) {
        HashMap<String, List> classToElements = new HashMap<String, List>();
        HashSet<String> predecessors = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String className = StringUtil.safe(element.getAttribute(classAttribute));
            classToElements.computeIfAbsent(className, k -> new ArrayList()).add(element);
            predecessors.addAll(PluginUtil.getPredecessors(element, predecessorAttribute));
            ++n2;
        }
        for (String predecessor : predecessors) {
            classToElements.remove(predecessor);
        }
        ArrayList result = new ArrayList();
        for (Map.Entry entry : classToElements.entrySet()) {
            List list = (List)entry.getValue();
            result.addAll(list);
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    private static Set<String> getPredecessors(IConfigurationElement element, String predecessorAttribute) {
        String value = element.getAttribute(predecessorAttribute);
        if (value == null) {
            return Collections.emptySet();
        }
        HashSet<String> predecessors = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, " ");
        while (tokenizer.hasMoreTokens()) {
            String predecessor = tokenizer.nextToken().trim();
            if (predecessor.length() == 0) continue;
            predecessors.add(predecessor);
        }
        return predecessors;
    }
}

