/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.report.internal.Messages;

public final class CategoryDescriptor {
    private CategoryDescriptor parent;
    private final String name;
    private final int sortOrder;
    private final List<Object> children;
    private boolean isSorted = false;

    CategoryDescriptor(String identifier) {
        if (identifier == null) {
            this.name = Messages.CategoryDescriptor_Label_NoCategory;
            this.sortOrder = Integer.MAX_VALUE;
        } else {
            int p = identifier.indexOf(124);
            String name1 = p >= 0 ? identifier.substring(p + 1) : identifier;
            int sortOrder = 100;
            int end = p;
            while (end > 0 && !Character.isDigit(identifier.charAt(end - 1))) {
                --end;
            }
            int start = 0;
            while (start < end) {
                try {
                    sortOrder = Integer.parseInt(identifier.substring(start, end));
                    name1 = String.valueOf(identifier.substring(0, start)) + name1;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    ++start;
                }
            }
            this.name = name1;
            this.sortOrder = sortOrder;
        }
        this.children = new ArrayList<Object>();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.parent == null) {
            return null;
        }
        String prefix = this.parent.getFullName();
        return prefix != null ? String.valueOf(prefix) + " / " + this.getName() : this.getName();
    }

    public List<Object> getChildren() {
        this.sort();
        return new ArrayList<Object>(this.children);
    }

    public List<CategoryDescriptor> getSubCategories() {
        this.sort();
        ArrayList<CategoryDescriptor> answer = new ArrayList<CategoryDescriptor>();
        for (Object child : this.children) {
            if (!(child instanceof CategoryDescriptor)) continue;
            answer.add((CategoryDescriptor)child);
        }
        return answer;
    }

    public List<QueryDescriptor> getQueries() {
        this.sort();
        ArrayList<QueryDescriptor> answer = new ArrayList<QueryDescriptor>();
        for (Object child : this.children) {
            if (!(child instanceof QueryDescriptor)) continue;
            answer.add((QueryDescriptor)child);
        }
        return answer;
    }

    private void sort() {
        if (!this.isSorted) {
            Collections.sort(this.children, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    int s2;
                    boolean isCat1 = o1 instanceof CategoryDescriptor;
                    boolean isCat2 = o2 instanceof CategoryDescriptor;
                    int s1 = isCat1 ? ((CategoryDescriptor)o1).sortOrder : ((QueryDescriptor)o1).sortOrder;
                    int n = s2 = isCat2 ? ((CategoryDescriptor)o2).sortOrder : ((QueryDescriptor)o2).sortOrder;
                    if (s1 < s2) {
                        return -1;
                    }
                    if (s1 > s2) {
                        return 1;
                    }
                    if (isCat1 ^ isCat2) {
                        return isCat1 ? -1 : 1;
                    }
                    String name1 = isCat1 ? ((CategoryDescriptor)o1).name : ((QueryDescriptor)o1).getName();
                    String name2 = isCat2 ? ((CategoryDescriptor)o2).name : ((QueryDescriptor)o2).getName();
                    return name1.compareTo(name2);
                }
            });
            this.isSorted = true;
        }
    }

    public void add(QueryDescriptor descriptor) {
        this.children.add(descriptor);
        this.isSorted = false;
    }

    public void add(CategoryDescriptor category) {
        this.children.add(category);
        this.isSorted = false;
    }

    public CategoryDescriptor resolve(String name) {
        int slash = name.indexOf(47);
        String subIdentifier = slash < 0 ? name : name.substring(0, slash);
        CategoryDescriptor newCat = new CategoryDescriptor(subIdentifier);
        String subName = newCat.getName();
        CategoryDescriptor subCat = null;
        for (Object child : this.children) {
            CategoryDescriptor c;
            if (!(child instanceof CategoryDescriptor) || !subName.equals((c = (CategoryDescriptor)child).getName())) continue;
            subCat = c;
            break;
        }
        if (subCat == null) {
            subCat = newCat;
            subCat.parent = this;
            this.children.add(subCat);
        }
        return slash < 0 ? subCat : subCat.resolve(name.substring(slash + 1));
    }

    public String toString() {
        return this.getName();
    }
}

